/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class LinkResolution {
    private static volatile ExecutorService executor;
    private static final int maxRecursions = 3;
    private static final String[] expectedUrlHostSuffixArray;

    private LinkResolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void resolveLink(String url, String[] resolveUrlSuffixArray, final LinkResolutionCallback linkResolutionCallback) {
        if (linkResolutionCallback == null) {
            return;
        }
        if (url == null) {
            linkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        URL originalURL = null;
        try {
            originalURL = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (originalURL == null) {
            linkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        if (!LinkResolution.urlMatchesSuffix(originalURL.getHost(), resolveUrlSuffixArray)) {
            linkResolutionCallback.resolvedLinkCallback(originalURL);
            return;
        }
        if (executor == null) {
            String[] stringArray = expectedUrlHostSuffixArray;
            // MONITORENTER : expectedUrlHostSuffixArray
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : stringArray
        }
        final URL finalOriginalURL = originalURL;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                LinkResolution.requestAndResolve(finalOriginalURL, 0, linkResolutionCallback);
            }
        });
    }

    private static void resolveLink(URL responseUrl, URL previousUrl, int recursionNumber, LinkResolutionCallback linkResolutionCallback) {
        if (responseUrl == null) {
            linkResolutionCallback.resolvedLinkCallback(previousUrl);
            return;
        }
        if (LinkResolution.isTerminalUrl(responseUrl.getHost())) {
            linkResolutionCallback.resolvedLinkCallback(responseUrl);
            return;
        }
        if (recursionNumber > 3) {
            linkResolutionCallback.resolvedLinkCallback(responseUrl);
            return;
        }
        LinkResolution.requestAndResolve(responseUrl, recursionNumber, linkResolutionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void requestAndResolve(URL urlToRequest, int recursionNumber, LinkResolutionCallback linkResolutionCallback) {
        URL resolvedURL;
        URL httpsUrl;
        block7: {
            httpsUrl = LinkResolution.convertToHttps(urlToRequest);
            resolvedURL = null;
            HttpURLConnection ucon = null;
            try {
                ucon = (HttpURLConnection)httpsUrl.openConnection();
                ucon.setInstanceFollowRedirects(false);
                ucon.connect();
                String headerLocationField = ucon.getHeaderField("Location");
                if (headerLocationField != null) {
                    resolvedURL = new URL(headerLocationField);
                }
                if (ucon == null) break block7;
                ucon.disconnect();
            }
            catch (Throwable throwable) {
                if (ucon != null) {
                    ucon.disconnect();
                }
                LinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, linkResolutionCallback);
                catch (Throwable throwable2) {
                    if (ucon != null) {
                        ucon.disconnect();
                    }
                    LinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, linkResolutionCallback);
                    throw throwable2;
                }
            }
        }
        LinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, linkResolutionCallback);
    }

    private static boolean isTerminalUrl(String urlHost) {
        return LinkResolution.urlMatchesSuffix(urlHost, expectedUrlHostSuffixArray);
    }

    private static boolean urlMatchesSuffix(String urlHost, String[] suffixArray) {
        if (urlHost == null) {
            return false;
        }
        if (suffixArray == null) {
            return false;
        }
        for (String expectedUrlHostSuffix : suffixArray) {
            if (!urlHost.endsWith(expectedUrlHostSuffix)) continue;
            return true;
        }
        return false;
    }

    private static URL convertToHttps(URL urlToConvert) {
        if (urlToConvert == null) {
            return urlToConvert;
        }
        String stringUrlToConvert = urlToConvert.toExternalForm();
        if (stringUrlToConvert == null) {
            return urlToConvert;
        }
        if (!stringUrlToConvert.startsWith("http:")) {
            return urlToConvert;
        }
        URL convertedUrl = urlToConvert;
        try {
            convertedUrl = new URL("https:" + stringUrlToConvert.substring(5));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return convertedUrl;
    }

    static {
        expectedUrlHostSuffixArray = new String[]{"adjust.com", "adj.st", "go.link"};
    }

    public static interface LinkResolutionCallback {
        public void resolvedLinkCallback(URL var1);
    }
}

