/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.SessionParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PackageFactory {
    private static final String ADJUST_PREFIX = "adjust_";

    public static ActivityPackage buildReftagSdkClickPackage(String rawReferrer, long clickTime, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        String referrer;
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return null;
        }
        try {
            referrer = URLDecoder.decode(rawReferrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
            AdjustFactory.getLogger().error("Referrer decoding failed due to UnsupportedEncodingException. Message: (%s)", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            referrer = "malformed";
            AdjustFactory.getLogger().error("Referrer decoding failed due to IllegalArgumentException. Message: (%s)", e.getMessage());
        }
        catch (Exception e) {
            referrer = "malformed";
            AdjustFactory.getLogger().error("Referrer decoding failed. Message: (%s)", e.getMessage());
        }
        AdjustFactory.getLogger().verbose("Referrer to parse (%s)", referrer);
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);
        PackageBuilder clickPackageBuilder = PackageFactory.queryStringClickPackageBuilder(querySanitizer.getParameterList(), activityState, adjustConfig, deviceInfo, sessionParameters);
        if (clickPackageBuilder == null) {
            return null;
        }
        clickPackageBuilder.referrer = referrer;
        clickPackageBuilder.clickTimeInMilliseconds = clickTime;
        clickPackageBuilder.rawReferrer = rawReferrer;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("reftag");
        return clickPackage;
    }

    public static ActivityPackage buildDeeplinkSdkClickPackage(Uri url, long clickTime, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        if (urlString == null || urlString.length() == 0) {
            return null;
        }
        AdjustFactory.getLogger().verbose("Url to parse (%s)", url);
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseUrl(urlString);
        PackageBuilder clickPackageBuilder = PackageFactory.queryStringClickPackageBuilder(querySanitizer.getParameterList(), activityState, adjustConfig, deviceInfo, sessionParameters);
        if (clickPackageBuilder == null) {
            return null;
        }
        clickPackageBuilder.deeplink = url.toString();
        clickPackageBuilder.clickTimeInMilliseconds = clickTime;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("deeplink");
        return clickPackage;
    }

    public static ActivityPackage buildInstallReferrerSdkClickPackage(String installReferrer, long clickTimeInSeconds, long installBeginInSeconds, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (installReferrer == null || installReferrer.length() == 0) {
            return null;
        }
        long now = System.currentTimeMillis();
        PackageBuilder clickPackageBuilder = new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, now);
        if (clickPackageBuilder == null) {
            return null;
        }
        clickPackageBuilder.referrer = installReferrer;
        clickPackageBuilder.clickTimeInSeconds = clickTimeInSeconds;
        clickPackageBuilder.installBeginTimeInSeconds = installBeginInSeconds;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("install_referrer");
        return clickPackage;
    }

    private static PackageBuilder queryStringClickPackageBuilder(List<UrlQuerySanitizer.ParameterValuePair> queryList, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (queryList == null) {
            return null;
        }
        LinkedHashMap<String, String> queryStringParameters = new LinkedHashMap<String, String>();
        AdjustAttribution queryStringAttribution = new AdjustAttribution();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : queryList) {
            PackageFactory.readQueryString(parameterValuePair.mParameter, parameterValuePair.mValue, queryStringParameters, queryStringAttribution);
        }
        long now = System.currentTimeMillis();
        String reftag = (String)queryStringParameters.remove("reftag");
        if (activityState != null) {
            long lastInterval;
            activityState.lastInterval = lastInterval = now - activityState.lastActivity;
        }
        PackageBuilder builder = new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, now);
        builder.extraParameters = queryStringParameters;
        builder.attribution = queryStringAttribution;
        builder.reftag = reftag;
        return builder;
    }

    private static boolean readQueryString(String key, String value, Map<String, String> extraParameters, AdjustAttribution queryStringAttribution) {
        if (key == null || value == null) {
            return false;
        }
        if (!key.startsWith(ADJUST_PREFIX)) {
            return false;
        }
        String keyWOutPrefix = key.substring(ADJUST_PREFIX.length());
        if (keyWOutPrefix.length() == 0) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        if (!PackageFactory.tryToSetAttribution(queryStringAttribution, keyWOutPrefix, value)) {
            extraParameters.put(keyWOutPrefix, value);
        }
        return true;
    }

    private static boolean tryToSetAttribution(AdjustAttribution queryStringAttribution, String key, String value) {
        if (key.equals("tracker")) {
            queryStringAttribution.trackerName = value;
            return true;
        }
        if (key.equals("campaign")) {
            queryStringAttribution.campaign = value;
            return true;
        }
        if (key.equals("adgroup")) {
            queryStringAttribution.adgroup = value;
            return true;
        }
        if (key.equals("creative")) {
            queryStringAttribution.creative = value;
            return true;
        }
        return false;
    }
}

