/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private IActivityHandler activityHandler;
    private ILogger logger = AdjustFactory.getLogger();
    private ActivityPackage attributionPackage;
    private TimerOnce timer;
    private boolean paused;
    private boolean hasListener;

    public AttributionHandler(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startPaused, boolean hasListener) {
        if (this.scheduler != null) {
            this.timer = new TimerOnce(this.scheduler, new Runnable(){

                @Override
                public void run() {
                    AttributionHandler.this.getAttributionInternal();
                }
            });
        } else {
            this.logger.error("Timer not initialized, attribution handler is disabled", new Object[0]);
        }
        this.init(activityHandler, attributionPackage, startPaused, hasListener);
    }

    @Override
    public void init(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startPaused, boolean hasListener) {
        this.activityHandler = activityHandler;
        this.attributionPackage = attributionPackage;
        this.paused = startPaused;
        this.hasListener = hasListener;
    }

    @Override
    public void getAttribution() {
        this.getAttribution(0L);
    }

    @Override
    public void checkAttribution(final JSONObject jsonResponse) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.checkAttributionInternal(jsonResponse);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void getAttribution(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            this.logger.debug("Waiting to query attribution in %d milliseconds", delayInMilliseconds);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionInternal(JSONObject jsonResponse) {
        if (jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = jsonResponse.optJSONObject("attribution");
        AdjustAttribution attribution = AdjustAttribution.fromJson(attributionJson);
        long timerMilliseconds = jsonResponse.optLong("ask_in", -1L);
        if (timerMilliseconds < 0L) {
            this.activityHandler.tryUpdateAttribution(attribution);
            this.activityHandler.setAskingAttribution(false);
            return;
        }
        this.activityHandler.setAskingAttribution(true);
        this.getAttribution(timerMilliseconds);
    }

    private void getAttributionInternal() {
        if (!this.hasListener) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        this.logger.verbose("%s", this.attributionPackage.getExtendedString());
        JSONObject jsonResponse = null;
        try {
            HttpsURLConnection connection = Util.createGETHttpsURLConnection(this.buildUri(this.attributionPackage.getPath(), this.attributionPackage.getParameters()).toString(), this.attributionPackage.getClientSdk());
            jsonResponse = Util.readHttpResponse(connection);
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return;
        }
        this.checkAttributionInternal(jsonResponse);
    }

    private Uri buildUri(String path, Map<String, String> parameters) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("https");
        uriBuilder.authority("app.adjust.com");
        uriBuilder.appendPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return uriBuilder.build();
    }
}

