/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.text.TextUtils;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PackageBuilder {
    private static ILogger logger = AdjustFactory.getLogger();
    private long createdAt;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private ActivityStateCopy activityStateCopy;
    private SessionParameters sessionParameters;
    long clickTimeInSeconds = -1L;
    long clickTimeInMilliseconds = -1L;
    long installBeginTimeInSeconds = -1L;
    String reftag;
    String deeplink;
    String referrer;
    String rawReferrer;
    AdjustAttribution attribution;
    Map<String, String> extraParameters;

    PackageBuilder(AdjustConfig adjustConfig, DeviceInfo deviceInfo, ActivityState activityState, SessionParameters sessionParameters, long createdAt) {
        this.createdAt = createdAt;
        this.deviceInfo = deviceInfo;
        this.adjustConfig = adjustConfig;
        this.activityStateCopy = new ActivityStateCopy(activityState);
        this.sessionParameters = sessionParameters;
    }

    ActivityPackage buildSessionPackage(boolean isInDelay) {
        Map<String, String> parameters = this.getSessionParameters(isInDelay);
        ActivityPackage sessionPackage = this.getDefaultActivityPackage(ActivityKind.SESSION);
        sessionPackage.setPath("/session");
        sessionPackage.setSuffix("");
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    ActivityPackage buildEventPackage(AdjustEvent event, boolean isInDelay) {
        Map<String, String> parameters = this.getEventParameters(event, isInDelay);
        ActivityPackage eventPackage = this.getDefaultActivityPackage(ActivityKind.EVENT);
        eventPackage.setPath("/event");
        eventPackage.setSuffix(this.getEventSuffix(event));
        eventPackage.setParameters(parameters);
        if (isInDelay) {
            eventPackage.setCallbackParameters(event.callbackParameters);
            eventPackage.setPartnerParameters(event.partnerParameters);
        }
        return eventPackage;
    }

    ActivityPackage buildInfoPackage(String source) {
        Map<String, String> parameters = this.getInfoParameters(source);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.INFO);
        clickPackage.setPath("/sdk_info");
        clickPackage.setSuffix("");
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    ActivityPackage buildClickPackage(String source) {
        Map<String, String> parameters = this.getClickParameters(source);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.CLICK);
        clickPackage.setPath("/sdk_click");
        clickPackage.setSuffix("");
        clickPackage.setClickTimeInMilliseconds(this.clickTimeInMilliseconds);
        clickPackage.setClickTimeInSeconds(this.clickTimeInSeconds);
        clickPackage.setInstallBeginTimeInSeconds(this.installBeginTimeInSeconds);
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    ActivityPackage buildAttributionPackage(String initiatedByDescription) {
        Map<String, String> parameters = this.getAttributionParameters(initiatedByDescription);
        ActivityPackage attributionPackage = this.getDefaultActivityPackage(ActivityKind.ATTRIBUTION);
        attributionPackage.setPath("attribution");
        attributionPackage.setSuffix("");
        attributionPackage.setParameters(parameters);
        return attributionPackage;
    }

    ActivityPackage buildGdprPackage() {
        Map<String, String> parameters = this.getGdprParameters();
        ActivityPackage gdprPackage = this.getDefaultActivityPackage(ActivityKind.GDPR);
        gdprPackage.setPath("/gdpr_forget_device");
        gdprPackage.setSuffix("");
        gdprPackage.setParameters(parameters);
        return gdprPackage;
    }

    ActivityPackage buildAdRevenuePackage(String source, JSONObject adRevenueJson) {
        Map<String, String> parameters = this.getAdRevenueParameters(source, adRevenueJson);
        ActivityPackage adRevenuePackage = this.getDefaultActivityPackage(ActivityKind.AD_REVENUE);
        adRevenuePackage.setPath("/ad_revenue");
        adRevenuePackage.setSuffix("");
        adRevenuePackage.setParameters(parameters);
        return adRevenuePackage;
    }

    private Map<String, String> getSessionParameters(boolean isInDelay) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
            PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    public Map<String, String> getEventParameters(AdjustEvent event, boolean isInDelay) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(this.sessionParameters.callbackParameters, event.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(this.sessionParameters.partnerParameters, event.partnerParameters, "Partner"));
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "currency", event.currency);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addString(parameters, "event_callback_id", event.callbackId);
        PackageBuilder.addLong(parameters, "event_count", this.activityStateCopy.eventCount);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "event_token", event.eventToken);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addDouble(parameters, "revenue", event.revenue);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getInfoParameters(String source) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getClickParameters(String source) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        if (this.attribution != null) {
            PackageBuilder.addString(parameters, "tracker", this.attribution.trackerName);
            PackageBuilder.addString(parameters, "campaign", this.attribution.campaign);
            PackageBuilder.addString(parameters, "adgroup", this.attribution.adgroup);
            PackageBuilder.addString(parameters, "creative", this.attribution.creative);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addMapJson(parameters, "callback_params", this.sessionParameters.callbackParameters);
        PackageBuilder.addDateInMilliseconds(parameters, "click_time", this.clickTimeInMilliseconds);
        PackageBuilder.addDateInSeconds(parameters, "click_time", this.clickTimeInSeconds);
        PackageBuilder.addLong(parameters, "connectivity_type", Util.getConnectivityType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addString(parameters, "deeplink", this.deeplink);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addDateInSeconds(parameters, "install_begin_time", this.installBeginTimeInSeconds);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "mcc", Util.getMcc(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "mnc", Util.getMnc(this.adjustConfig.context));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addLong(parameters, "network_type", Util.getNetworkType(this.adjustConfig.context));
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addMapJson(parameters, "params", this.extraParameters);
        PackageBuilder.addMapJson(parameters, "partner_params", this.sessionParameters.partnerParameters);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "raw_referrer", this.rawReferrer);
        PackageBuilder.addString(parameters, "referrer", this.referrer);
        PackageBuilder.addString(parameters, "reftag", this.reftag);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addLong(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addLong(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAttributionParameters(String initiatedBy) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addString(parameters, "initiated_by", initiatedBy);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getGdprParameters() {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getAdRevenueParameters(String source, JSONObject adRevenueJson) {
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> imeiParameters = Reflection.getImeiParameters(this.adjustConfig.context, logger);
        if (imeiParameters != null) {
            parameters.putAll(imeiParameters);
        }
        this.deviceInfo.reloadPlayIds(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", this.deviceInfo.isTrackingEnabled);
        PackageBuilder.addString(parameters, "gps_adid", this.deviceInfo.playAdId);
        PackageBuilder.addString(parameters, "gps_adid_src", this.deviceInfo.playAdIdSource);
        if (!this.containsPlayIds(parameters)) {
            logger.warn("Google Advertising ID not detected, fallback to non Google Play identifiers will take place", new Object[0]);
            this.deviceInfo.reloadNonPlayIds(this.adjustConfig.context);
            PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
            PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
            PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
        }
        PackageBuilder.addString(parameters, "app_secret", this.adjustConfig.appSecret);
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
        PackageBuilder.addDateInMilliseconds(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "fire_adid", Util.getFireAdvertisingId(contentResolver));
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", Util.getFireTrackingEnabled(contentResolver));
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        PackageBuilder.addString(parameters, "secret_id", this.adjustConfig.secretId);
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addJsonObject(parameters, "payload", adRevenueJson);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private ActivityPackage getDefaultActivityPackage(ActivityKind activityKind) {
        ActivityPackage activityPackage = new ActivityPackage(activityKind);
        activityPackage.setClientSdk(this.deviceInfo.clientSdk);
        return activityPackage;
    }

    public static void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    public static void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        PackageBuilder.addLong(parameters, key, intValue);
    }

    static void addJsonObject(Map<String, String> parameters, String key, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        PackageBuilder.addString(parameters, key, jsonObject.toString());
    }

    static void addMapJson(Map<String, String> parameters, String key, Map<String, String> map) {
        if (map == null) {
            return;
        }
        if (map.size() == 0) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        PackageBuilder.addString(parameters, key, jsonString);
    }

    private static void addLong(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        PackageBuilder.addString(parameters, key, valueString);
    }

    private static void addDateInMilliseconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDateInSeconds(Map<String, String> parameters, String key, long value) {
        if (value <= 0L) {
            return;
        }
        Date date = new Date(value * 1000L);
        PackageBuilder.addDate(parameters, key, date);
    }

    private static void addDate(Map<String, String> parameters, String key, Date value) {
        if (value == null) {
            return;
        }
        String dateString = Util.dateFormatter.format(value);
        PackageBuilder.addString(parameters, key, dateString);
    }

    private static void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        PackageBuilder.addLong(parameters, key, durationInSeconds);
    }

    private static void addDouble(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = Util.formatString("%.5f", value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private boolean containsPlayIds(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        return parameters.containsKey("tracking_enabled") || parameters.containsKey("gps_adid");
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters == null || parameters.containsKey("mac_sha1") || parameters.containsKey("mac_md5") || parameters.containsKey("android_id") || parameters.containsKey("gps_adid"))) {
            logger.error("Missing device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
        }
    }

    private String getEventSuffix(AdjustEvent event) {
        if (event.revenue == null) {
            return Util.formatString("'%s'", event.eventToken);
        }
        return Util.formatString("(%.5f %s, '%s')", event.revenue, event.currency, event.eventToken);
    }

    private class ActivityStateCopy {
        int eventCount = -1;
        int sessionCount = -1;
        int subsessionCount = -1;
        long timeSpent = -1L;
        long lastInterval = -1L;
        long sessionLength = -1L;
        String uuid = null;
        String pushToken = null;

        ActivityStateCopy(ActivityState activityState) {
            if (activityState == null) {
                return;
            }
            this.eventCount = activityState.eventCount;
            this.sessionCount = activityState.sessionCount;
            this.subsessionCount = activityState.subsessionCount;
            this.timeSpent = activityState.timeSpent;
            this.lastInterval = activityState.lastInterval;
            this.sessionLength = activityState.sessionLength;
            this.uuid = activityState.uuid;
            this.pushToken = activityState.pushToken;
        }
    }
}

