/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class UtilNetworking {
    private static String userAgent;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static void setUserAgent(String userAgent) {
        UtilNetworking.userAgent = userAgent;
    }

    public static ResponseData createPOSTHttpsURLConnection(String urlString, ActivityPackage activityPackage, int queueSize) throws Exception {
        DataOutputStream wr = null;
        try {
            ResponseData responseData;
            URL url = new URL(urlString);
            HttpsURLConnection connection = AdjustFactory.getHttpsURLConnection(url);
            HashMap<String, String> parameters = new HashMap<String, String>(activityPackage.getParameters());
            IConnectionOptions connectionOptions = AdjustFactory.getConnectionOptions();
            connectionOptions.applyConnectionOptions(connection, activityPackage.getClientSdk());
            String appSecret = UtilNetworking.extractAppSecret(parameters);
            String secretId = UtilNetworking.extractSecretId(parameters);
            String authorizationHeader = UtilNetworking.buildAuthorizationHeader(parameters, appSecret, secretId, activityPackage.getActivityKind().toString());
            if (authorizationHeader != null) {
                connection.setRequestProperty("Authorization", authorizationHeader);
            }
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(UtilNetworking.getPostDataString(parameters, queueSize));
            ResponseData responseData2 = responseData = UtilNetworking.readHttpResponse(connection, activityPackage);
            return responseData2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (wr != null) {
                    wr.flush();
                    wr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static ResponseData createGETHttpsURLConnection(ActivityPackage activityPackage, String basePath) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(activityPackage.getParameters());
        String appSecret = UtilNetworking.extractAppSecret(parameters);
        String secretId = UtilNetworking.extractSecretId(parameters);
        Uri uri = UtilNetworking.buildUri(activityPackage.getPath(), parameters, basePath);
        URL url = new URL(uri.toString());
        HttpsURLConnection connection = AdjustFactory.getHttpsURLConnection(url);
        IConnectionOptions connectionOptions = AdjustFactory.getConnectionOptions();
        connectionOptions.applyConnectionOptions(connection, activityPackage.getClientSdk());
        String authorizationHeader = UtilNetworking.buildAuthorizationHeader(parameters, appSecret, secretId, activityPackage.getActivityKind().toString());
        if (authorizationHeader != null) {
            connection.setRequestProperty("Authorization", authorizationHeader);
        }
        connection.setRequestMethod("GET");
        ResponseData responseData = UtilNetworking.readHttpResponse(connection, activityPackage);
        return responseData;
    }

    private static ResponseData readHttpResponse(HttpsURLConnection connection, ActivityPackage activityPackage) throws Exception {
        String message;
        StringBuffer sb = new StringBuffer();
        ILogger logger = UtilNetworking.getLogger();
        Integer responseCode = null;
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        try {
            String line;
            connection.connect();
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            logger.error("Failed to read response. (%s)", e.getMessage());
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        String stringResponse = sb.toString();
        logger.verbose("Response: %s", stringResponse);
        if (stringResponse == null || stringResponse.length() == 0) {
            return responseData;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(stringResponse);
        }
        catch (JSONException e) {
            String message2 = Util.formatString("Failed to parse json response. (%s)", e.getMessage());
            logger.error(message2, new Object[0]);
            responseData.message = message2;
        }
        if (jsonResponse == null) {
            return responseData;
        }
        responseData.jsonResponse = jsonResponse;
        responseData.message = message = jsonResponse.optString("message", null);
        responseData.timestamp = jsonResponse.optString("timestamp", null);
        responseData.adid = jsonResponse.optString("adid", null);
        if (message == null) {
            message = "No message found";
        }
        if (responseCode != null && responseCode == 200) {
            logger.info("%s", message);
            responseData.success = true;
        } else {
            logger.error("%s", message);
        }
        return responseData;
    }

    private static String getPostDataString(Map<String, String> body, int queueSize) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : body.entrySet()) {
            String encodedValue;
            String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
            String value = entry.getValue();
            String string = encodedValue = value != null ? URLEncoder.encode(value, "UTF-8") : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        result.append("&");
        result.append(URLEncoder.encode("sent_at", "UTF-8"));
        result.append("=");
        result.append(URLEncoder.encode(dateString, "UTF-8"));
        if (queueSize > 0) {
            result.append("&");
            result.append(URLEncoder.encode("queue_size", "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode("" + queueSize, "UTF-8"));
        }
        return result.toString();
    }

    private static Uri buildUri(String path, Map<String, String> parameters, String basePath) {
        Uri.Builder uriBuilder = new Uri.Builder();
        String scheme = "https";
        String authority = "app.adjust.com";
        String initialPath = "";
        try {
            String url = AdjustFactory.getBaseUrl();
            if (basePath != null) {
                url = url + basePath;
            }
            URL baseUrl = new URL(url);
            scheme = baseUrl.getProtocol();
            authority = baseUrl.getAuthority();
            initialPath = baseUrl.getPath();
        }
        catch (MalformedURLException e) {
            UtilNetworking.getLogger().error("Unable to parse endpoint (%s)", e.getMessage());
        }
        uriBuilder.scheme(scheme);
        uriBuilder.encodedAuthority(authority);
        uriBuilder.path(initialPath);
        uriBuilder.appendPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        uriBuilder.appendQueryParameter("sent_at", dateString);
        return uriBuilder.build();
    }

    private static String extractAppSecret(Map<String, String> parameters) {
        return parameters.remove("app_secret");
    }

    private static String extractSecretId(Map<String, String> parameters) {
        return parameters.remove("secret_id");
    }

    private static String buildAuthorizationHeader(Map<String, String> parameters, String appSecret, String secretId, String activityKind) {
        if (appSecret == null || appSecret.length() == 0) {
            return null;
        }
        String appSecretName = "app_secret";
        Map<String, String> signatureDetails = UtilNetworking.getSignature(parameters, activityKind, appSecret);
        String algorithm = "sha256";
        String signature = Util.sha256(signatureDetails.get("clear_signature"));
        String fields = signatureDetails.get("fields");
        String secretIdHeader = Util.formatString("secret_id=\"%s\"", secretId);
        String signatureHeader = Util.formatString("signature=\"%s\"", signature);
        String algorithmHeader = Util.formatString("algorithm=\"%s\"", algorithm);
        String fieldsHeader = Util.formatString("headers=\"%s\"", fields);
        String authorizationHeader = Util.formatString("Signature %s,%s,%s,%s", secretIdHeader, signatureHeader, algorithmHeader, fieldsHeader);
        UtilNetworking.getLogger().verbose("authorizationHeader: %s", authorizationHeader);
        return authorizationHeader;
    }

    private static Map<String, String> getSignature(Map<String, String> parameters, String activityKind, String appSecret) {
        String activityKindName = "activity_kind";
        String activityKindValue = activityKind;
        String createdAtName = "created_at";
        String createdAt = parameters.get(createdAtName);
        String deviceIdentifierName = UtilNetworking.getValidIdentifier(parameters);
        String deviceIdentifier = parameters.get(deviceIdentifierName);
        HashMap<String, String> signatureParams = new HashMap<String, String>();
        signatureParams.put("app_secret", appSecret);
        signatureParams.put(createdAtName, createdAt);
        signatureParams.put(activityKindName, activityKindValue);
        signatureParams.put(deviceIdentifierName, deviceIdentifier);
        String fields = "";
        String clearSignature = "";
        for (Map.Entry entry : signatureParams.entrySet()) {
            if (entry.getValue() == null) continue;
            fields = fields + (String)entry.getKey() + " ";
            clearSignature = clearSignature + (String)entry.getValue();
        }
        fields = fields.substring(0, fields.length() - 1);
        HashMap<String, String> signature = new HashMap<String, String>();
        signature.put("clear_signature", clearSignature);
        signature.put("fields", fields);
        return signature;
    }

    private static String getValidIdentifier(Map<String, String> parameters) {
        String googleAdIdName = "gps_adid";
        String fireAdIdName = "fire_adid";
        String androidIdName = "android_id";
        String macSha1Name = "mac_sha1";
        String macMd5Name = "mac_md5";
        String androidUUIDName = "android_uuid";
        if (parameters.get(googleAdIdName) != null) {
            return googleAdIdName;
        }
        if (parameters.get(fireAdIdName) != null) {
            return fireAdIdName;
        }
        if (parameters.get(androidIdName) != null) {
            return androidIdName;
        }
        if (parameters.get(macSha1Name) != null) {
            return macSha1Name;
        }
        if (parameters.get(macMd5Name) != null) {
            return macMd5Name;
        }
        if (parameters.get(androidUUIDName) != null) {
            return androidUUIDName;
        }
        return null;
    }

    static class ConnectionOptions
    implements IConnectionOptions {
        ConnectionOptions() {
        }

        @Override
        public void applyConnectionOptions(HttpsURLConnection connection, String clientSdk) {
            connection.setRequestProperty("Client-SDK", clientSdk);
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            if (userAgent != null) {
                connection.setRequestProperty("User-Agent", userAgent);
            }
        }
    }

    public static interface IConnectionOptions {
        public void applyConnectionOptions(HttpsURLConnection var1, String var2);
    }
}

