/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SdkClickHandler
implements ISdkClickHandler {
    private CustomScheduledExecutor scheduledExecutor;
    private ILogger logger;
    private boolean paused;
    private List<ActivityPackage> packageQueue;
    private BackoffStrategy backoffStrategy;

    @Override
    public void teardown() {
        this.logger.verbose("SdkClickHandler teardown", new Object[0]);
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        this.scheduledExecutor = null;
        this.logger = null;
        this.packageQueue = null;
        this.backoffStrategy = null;
    }

    public SdkClickHandler(boolean startsSending) {
        this.init(startsSending);
        this.logger = AdjustFactory.getLogger();
        this.scheduledExecutor = new CustomScheduledExecutor("SdkClickHandler", false);
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
    }

    @Override
    public void init(boolean startsSending) {
        this.paused = !startsSending;
        this.packageQueue = new ArrayList<ActivityPackage>();
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage sdkClick) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.packageQueue.add(sdkClick);
                SdkClickHandler.this.logger.debug("Added sdk_click %d", SdkClickHandler.this.packageQueue.size());
                SdkClickHandler.this.logger.verbose("%s", sdkClick.getExtendedString());
                SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    private void sendNextSdkClick() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendNextSdkClickI();
            }
        });
    }

    private void sendNextSdkClickI() {
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        final ActivityPackage sdkClickPackage = this.packageQueue.remove(0);
        int retries = sdkClickPackage.getRetries();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendSdkClickI(sdkClickPackage);
                SdkClickHandler.this.sendNextSdkClick();
            }
        };
        if (retries <= 0) {
            runnable.run();
            return;
        }
        long waitTimeMilliSeconds = Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying sdk_click for the %d time", secondsString, retries);
        this.scheduledExecutor.schedule(runnable, waitTimeMilliSeconds, TimeUnit.MILLISECONDS);
    }

    private void sendSdkClickI(ActivityPackage sdkClickPackage) {
        String targetURL = "https://app.adjust.com" + sdkClickPackage.getPath();
        try {
            ResponseData responseData = UtilNetworking.createPOSTHttpsURLConnection(targetURL, sdkClickPackage, this.packageQueue.size() - 1);
            if (responseData.jsonResponse == null) {
                this.retrySendingI(sdkClickPackage);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click request timed out. Will retry later", e);
            this.retrySendingI(sdkClickPackage);
        }
        catch (IOException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click request failed. Will retry later", e);
            this.retrySendingI(sdkClickPackage);
        }
        catch (Throwable e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click runtime exception", e);
        }
    }

    private void retrySendingI(ActivityPackage sdkClickPackage) {
        int retries = sdkClickPackage.increaseRetries();
        this.logger.error("Retrying sdk_click package for the %d time", retries);
        this.sendSdkClick(sdkClickPackage);
    }

    private void logErrorMessageI(ActivityPackage sdkClickPackage, String message, Throwable throwable) {
        String packageMessage = sdkClickPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s)", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
    }
}

