/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.text.TextUtils;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

class PackageBuilder {
    private AdjustConfig adjustConfig;
    private DeviceInfo deviceInfo;
    private ActivityStateCopy activityStateCopy;
    private long createdAt;
    Map<String, String> extraParameters;
    AdjustAttribution attribution;
    String reftag;
    String referrer;
    String deeplink;
    long clickTime;
    private static ILogger logger = AdjustFactory.getLogger();

    public PackageBuilder(AdjustConfig adjustConfig, DeviceInfo deviceInfo, ActivityState activityState, long createdAt) {
        this.adjustConfig = adjustConfig;
        this.deviceInfo = deviceInfo;
        this.activityStateCopy = new ActivityStateCopy(activityState);
        this.createdAt = createdAt;
    }

    public ActivityPackage buildSessionPackage(SessionParameters sessionParameters, boolean isInDelay) {
        Map<String, String> parameters = this.getDefaultParameters();
        PackageBuilder.addDuration(parameters, "last_interval", this.activityStateCopy.lastInterval);
        PackageBuilder.addString(parameters, "default_tracker", this.adjustConfig.defaultTracker);
        PackageBuilder.addString(parameters, "installed_at", this.deviceInfo.appInstallTime);
        PackageBuilder.addString(parameters, "updated_at", this.deviceInfo.appUpdateTime);
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", sessionParameters.callbackParameters);
            PackageBuilder.addMapJson(parameters, "partner_params", sessionParameters.partnerParameters);
        }
        ActivityPackage sessionPackage = this.getDefaultActivityPackage(ActivityKind.SESSION);
        sessionPackage.setPath("/session");
        sessionPackage.setSuffix("");
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    public ActivityPackage buildEventPackage(AdjustEvent event, SessionParameters sessionParameters, boolean isInDelay) {
        Map<String, String> parameters = this.getDefaultParameters();
        PackageBuilder.addInt(parameters, "event_count", this.activityStateCopy.eventCount);
        PackageBuilder.addString(parameters, "event_token", event.eventToken);
        PackageBuilder.addDouble(parameters, "revenue", event.revenue);
        PackageBuilder.addString(parameters, "currency", event.currency);
        if (!isInDelay) {
            PackageBuilder.addMapJson(parameters, "callback_params", Util.mergeParameters(sessionParameters.callbackParameters, event.callbackParameters, "Callback"));
            PackageBuilder.addMapJson(parameters, "partner_params", Util.mergeParameters(sessionParameters.partnerParameters, event.partnerParameters, "Partner"));
        }
        ActivityPackage eventPackage = this.getDefaultActivityPackage(ActivityKind.EVENT);
        eventPackage.setPath("/event");
        eventPackage.setSuffix(this.getEventSuffix(event));
        eventPackage.setParameters(parameters);
        if (isInDelay) {
            eventPackage.setCallbackParameters(event.callbackParameters);
            eventPackage.setPartnerParameters(event.partnerParameters);
        }
        return eventPackage;
    }

    public ActivityPackage buildClickPackage(String source) {
        Map<String, String> parameters = this.getIdsParameters();
        PackageBuilder.addString(parameters, "source", source);
        PackageBuilder.addDate(parameters, "click_time", this.clickTime);
        PackageBuilder.addString(parameters, "reftag", this.reftag);
        PackageBuilder.addMapJson(parameters, "params", this.extraParameters);
        PackageBuilder.addString(parameters, "referrer", this.referrer);
        PackageBuilder.addString(parameters, "deeplink", this.deeplink);
        this.injectAttribution(parameters);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.CLICK);
        clickPackage.setPath("/sdk_click");
        clickPackage.setSuffix("");
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    public ActivityPackage buildInfoPackage(String source) {
        Map<String, String> parameters = this.getIdsParameters();
        PackageBuilder.addString(parameters, "source", source);
        ActivityPackage clickPackage = this.getDefaultActivityPackage(ActivityKind.INFO);
        clickPackage.setPath("/sdk_info");
        clickPackage.setSuffix("");
        clickPackage.setParameters(parameters);
        return clickPackage;
    }

    public ActivityPackage buildAttributionPackage() {
        Map<String, String> parameters = this.getIdsParameters();
        ActivityPackage attributionPackage = this.getDefaultActivityPackage(ActivityKind.ATTRIBUTION);
        attributionPackage.setPath("attribution");
        attributionPackage.setSuffix("");
        attributionPackage.setParameters(parameters);
        return attributionPackage;
    }

    private ActivityPackage getDefaultActivityPackage(ActivityKind activityKind) {
        ActivityPackage activityPackage = new ActivityPackage(activityKind);
        activityPackage.setClientSdk(this.deviceInfo.clientSdk);
        return activityPackage;
    }

    private Map<String, String> getDefaultParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.injectDeviceInfo(parameters);
        this.injectConfig(parameters);
        this.injectActivityState(parameters);
        this.injectCommonParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private Map<String, String> getIdsParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.injectDeviceInfoIds(parameters);
        this.injectConfig(parameters);
        this.injectCommonParameters(parameters);
        this.checkDeviceIds(parameters);
        return parameters;
    }

    private void injectDeviceInfo(Map<String, String> parameters) {
        this.injectDeviceInfoIds(parameters);
        PackageBuilder.addString(parameters, "fb_id", this.deviceInfo.fbAttributionId);
        PackageBuilder.addString(parameters, "package_name", this.deviceInfo.packageName);
        PackageBuilder.addString(parameters, "app_version", this.deviceInfo.appVersion);
        PackageBuilder.addString(parameters, "device_type", this.deviceInfo.deviceType);
        PackageBuilder.addString(parameters, "device_name", this.deviceInfo.deviceName);
        PackageBuilder.addString(parameters, "device_manufacturer", this.deviceInfo.deviceManufacturer);
        PackageBuilder.addString(parameters, "os_name", this.deviceInfo.osName);
        PackageBuilder.addString(parameters, "os_version", this.deviceInfo.osVersion);
        PackageBuilder.addString(parameters, "api_level", this.deviceInfo.apiLevel);
        PackageBuilder.addString(parameters, "language", this.deviceInfo.language);
        PackageBuilder.addString(parameters, "country", this.deviceInfo.country);
        PackageBuilder.addString(parameters, "screen_size", this.deviceInfo.screenSize);
        PackageBuilder.addString(parameters, "screen_format", this.deviceInfo.screenFormat);
        PackageBuilder.addString(parameters, "screen_density", this.deviceInfo.screenDensity);
        PackageBuilder.addString(parameters, "display_width", this.deviceInfo.displayWidth);
        PackageBuilder.addString(parameters, "display_height", this.deviceInfo.displayHeight);
        PackageBuilder.addString(parameters, "hardware_name", this.deviceInfo.hardwareName);
        PackageBuilder.addString(parameters, "cpu_type", this.deviceInfo.abi);
        PackageBuilder.addString(parameters, "os_build", this.deviceInfo.buildName);
        PackageBuilder.addString(parameters, "vm_isa", this.deviceInfo.vmInstructionSet);
        this.fillPluginKeys(parameters);
    }

    private void injectDeviceInfoIds(Map<String, String> parameters) {
        PackageBuilder.addString(parameters, "mac_sha1", this.deviceInfo.macSha1);
        PackageBuilder.addString(parameters, "mac_md5", this.deviceInfo.macShortMd5);
        PackageBuilder.addString(parameters, "android_id", this.deviceInfo.androidId);
    }

    private void injectConfig(Map<String, String> parameters) {
        PackageBuilder.addString(parameters, "app_token", this.adjustConfig.appToken);
        PackageBuilder.addString(parameters, "environment", this.adjustConfig.environment);
        PackageBuilder.addBoolean(parameters, "device_known", this.adjustConfig.deviceKnown);
        PackageBuilder.addBoolean(parameters, "needs_response_details", true);
        String playAdId = Util.getPlayAdId(this.adjustConfig.context);
        PackageBuilder.addString(parameters, "gps_adid", playAdId);
        Boolean isTrackingEnabled = Util.isPlayTrackingEnabled(this.adjustConfig.context);
        PackageBuilder.addBoolean(parameters, "tracking_enabled", isTrackingEnabled);
        PackageBuilder.addBoolean(parameters, "event_buffering_enabled", this.adjustConfig.eventBufferingEnabled);
        PackageBuilder.addString(parameters, "push_token", this.activityStateCopy.pushToken);
        ContentResolver contentResolver = this.adjustConfig.context.getContentResolver();
        String fireAdId = Util.getFireAdvertisingId(contentResolver);
        PackageBuilder.addString(parameters, "fire_adid", fireAdId);
        Boolean fireTrackingEnabled = Util.getFireTrackingEnabled(contentResolver);
        PackageBuilder.addBoolean(parameters, "fire_tracking_enabled", fireTrackingEnabled);
    }

    private void injectActivityState(Map<String, String> parameters) {
        PackageBuilder.addString(parameters, "android_uuid", this.activityStateCopy.uuid);
        PackageBuilder.addInt(parameters, "session_count", this.activityStateCopy.sessionCount);
        PackageBuilder.addInt(parameters, "subsession_count", this.activityStateCopy.subsessionCount);
        PackageBuilder.addDuration(parameters, "session_length", this.activityStateCopy.sessionLength);
        PackageBuilder.addDuration(parameters, "time_spent", this.activityStateCopy.timeSpent);
    }

    private void injectCommonParameters(Map<String, String> parameters) {
        PackageBuilder.addDate(parameters, "created_at", this.createdAt);
        PackageBuilder.addBoolean(parameters, "attribution_deeplink", true);
    }

    private void injectAttribution(Map<String, String> parameters) {
        if (this.attribution == null) {
            return;
        }
        PackageBuilder.addString(parameters, "tracker", this.attribution.trackerName);
        PackageBuilder.addString(parameters, "campaign", this.attribution.campaign);
        PackageBuilder.addString(parameters, "adgroup", this.attribution.adgroup);
        PackageBuilder.addString(parameters, "creative", this.attribution.creative);
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters.containsKey("mac_sha1") || parameters.containsKey("mac_md5") || parameters.containsKey("android_id") || parameters.containsKey("gps_adid"))) {
            logger.error("Missing device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
        }
    }

    private void fillPluginKeys(Map<String, String> parameters) {
        if (this.deviceInfo.pluginKeys == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.deviceInfo.pluginKeys.entrySet()) {
            PackageBuilder.addString(parameters, entry.getKey(), entry.getValue());
        }
    }

    private String getEventSuffix(AdjustEvent event) {
        if (event.revenue == null) {
            return String.format(Locale.US, "'%s'", event.eventToken);
        }
        return String.format(Locale.US, "(%.5f %s, '%s')", event.revenue, event.currency, event.eventToken);
    }

    public static void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    public static void addInt(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        PackageBuilder.addString(parameters, key, valueString);
    }

    public static void addDate(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String dateString = Util.dateFormatter.format(value);
        PackageBuilder.addString(parameters, key, dateString);
    }

    public static void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        PackageBuilder.addInt(parameters, key, durationInSeconds);
    }

    public static void addMapJson(Map<String, String> parameters, String key, Map<String, String> map) {
        if (map == null) {
            return;
        }
        if (map.size() == 0) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        PackageBuilder.addString(parameters, key, jsonString);
    }

    public static void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        PackageBuilder.addInt(parameters, key, intValue);
    }

    public static void addDouble(Map<String, String> parameters, String key, Double value) {
        if (value == null) {
            return;
        }
        String doubleString = String.format(Locale.US, "%.5f", value);
        PackageBuilder.addString(parameters, key, doubleString);
    }

    private class ActivityStateCopy {
        long lastInterval = -1L;
        int eventCount = -1;
        String uuid = null;
        int sessionCount = -1;
        int subsessionCount = -1;
        long sessionLength = -1L;
        long timeSpent = -1L;
        String pushToken = null;

        ActivityStateCopy(ActivityState activityState) {
            if (activityState == null) {
                return;
            }
            this.lastInterval = activityState.lastInterval;
            this.eventCount = activityState.eventCount;
            this.uuid = activityState.uuid;
            this.sessionCount = activityState.sessionCount;
            this.subsessionCount = activityState.subsessionCount;
            this.sessionLength = activityState.sessionLength;
            this.timeSpent = activityState.timeSpent;
            this.pushToken = activityState.pushToken;
        }
    }
}

