/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.SessionResponseData;
import java.util.Locale;
import org.json.JSONObject;

public class ResponseData {
    public ActivityKind activityKind;
    public String message;
    public String timestamp;
    public String adid;
    public boolean success;
    public boolean willRetry;
    public JSONObject jsonResponse;
    public AdjustAttribution attribution;

    protected ResponseData() {
    }

    public static ResponseData buildResponseData(ActivityPackage activityPackage) {
        ResponseData responseData;
        ActivityKind activityKind = activityPackage.getActivityKind();
        switch (activityKind) {
            case SESSION: {
                responseData = new SessionResponseData();
                break;
            }
            case ATTRIBUTION: {
                responseData = new AttributionResponseData();
                break;
            }
            case EVENT: {
                responseData = new EventResponseData(activityPackage);
                break;
            }
            default: {
                responseData = new ResponseData();
            }
        }
        responseData.activityKind = activityKind;
        return responseData;
    }

    public String toString() {
        return String.format(Locale.US, "message:%s timestamp:%s json:%s", this.message, this.timestamp, this.jsonResponse);
    }
}

