/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private CustomScheduledExecutor scheduledExecutor = new CustomScheduledExecutor("AttributionHandler");
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private ILogger logger = AdjustFactory.getLogger();
    private ActivityPackage attributionPackage;
    private TimerOnce timer;
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;
    private boolean hasListener;
    public URL lastUrlUsed;

    @Override
    public void teardown() {
        this.logger.verbose("AttributionHandler teardown", new Object[0]);
        if (this.timer != null) {
            this.timer.teardown();
        }
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.scheduledExecutor = null;
        this.activityHandlerWeakRef = null;
        this.logger = null;
        this.attributionPackage = null;
        this.timer = null;
    }

    public AttributionHandler(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending, boolean hasListener) {
        if (this.scheduledExecutor != null) {
            this.timer = new TimerOnce(this.scheduledExecutor, new Runnable(){

                @Override
                public void run() {
                    AttributionHandler.this.getAttributionI();
                }
            }, ATTRIBUTION_TIMER_NAME);
        } else {
            this.logger.error("Timer not initialized, attribution handler is disabled", new Object[0]);
        }
        this.init(activityHandler, attributionPackage, startsSending, hasListener);
    }

    @Override
    public void init(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending, boolean hasListener) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.attributionPackage = attributionPackage;
        this.paused = !startsSending;
        this.hasListener = hasListener;
    }

    @Override
    public void getAttribution() {
        this.getAttribution(0L);
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSessionResponseI(activityHandler, sessionResponseData);
            }
        });
    }

    public void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(activityHandler, attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void getAttribution(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            double waitTimeSeconds = (double)delayInMilliseconds / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.debug("Waiting to query attribution in %s seconds", secondsString);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionI(IActivityHandler activityHandler, ResponseData responseData) {
        if (responseData.jsonResponse == null) {
            return;
        }
        long timerMilliseconds = responseData.jsonResponse.optLong("ask_in", -1L);
        if (timerMilliseconds >= 0L) {
            activityHandler.setAskingAttribution(true);
            this.getAttribution(timerMilliseconds);
            return;
        }
        activityHandler.setAskingAttribution(false);
        JSONObject attributionJson = responseData.jsonResponse.optJSONObject("attribution");
        responseData.attribution = AdjustAttribution.fromJson(attributionJson);
    }

    private void checkSessionResponseI(IActivityHandler activityHandler, SessionResponseData sessionResponseData) {
        this.checkAttributionI(activityHandler, sessionResponseData);
        activityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkAttributionResponseI(IActivityHandler activityHandler, AttributionResponseData attributionResponseData) {
        this.checkAttributionI(activityHandler, attributionResponseData);
        this.checkDeeplinkI(attributionResponseData);
        activityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void checkDeeplinkI(AttributionResponseData attributionResponseData) {
        if (attributionResponseData.jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = attributionResponseData.jsonResponse.optJSONObject("attribution");
        if (attributionJson == null) {
            return;
        }
        String deeplinkString = attributionJson.optString("deeplink", null);
        if (deeplinkString == null) {
            return;
        }
        attributionResponseData.deeplink = Uri.parse((String)deeplinkString);
    }

    private void getAttributionI() {
        if (!this.hasListener) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        this.logger.verbose("%s", this.attributionPackage.getExtendedString());
        try {
            AdjustFactory.URLGetConnection urlGetConnection = Util.createGETHttpsURLConnection(this.buildUriI(this.attributionPackage.getPath(), this.attributionPackage.getParameters()).toString(), this.attributionPackage.getClientSdk());
            ResponseData responseData = Util.readHttpResponse(urlGetConnection.httpsURLConnection, this.attributionPackage);
            this.lastUrlUsed = urlGetConnection.url;
            if (!(responseData instanceof AttributionResponseData)) {
                return;
            }
            this.checkAttributionResponse((AttributionResponseData)responseData);
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return;
        }
    }

    private Uri buildUriI(String path, Map<String, String> parameters) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("https");
        uriBuilder.authority("app.adjust.com");
        uriBuilder.appendPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        uriBuilder.appendQueryParameter("sent_at", dateString);
        return uriBuilder.build();
    }
}

