/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.Util;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class ActivityHandler
extends HandlerThread
implements IActivityHandler {
    private static long TIMER_INTERVAL;
    private static long TIMER_START;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ADJUST_PREFIX = "adjust_";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private SessionHandler sessionHandler;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private static ScheduledExecutorService timer;
    private boolean enabled;
    private boolean offline;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;

    private ActivityHandler(AdjustConfig adjustConfig) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.logger = AdjustFactory.getLogger();
        this.sessionHandler = new SessionHandler(this.getLooper(), this);
        this.enabled = true;
        this.init(adjustConfig);
        Message message = Message.obtain();
        message.arg1 = 72631;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    public static ActivityHandler getInstance(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (adjustConfig.processName != null) {
            int currentPid = Process.myPid();
            ActivityManager manager = (ActivityManager)adjustConfig.context.getSystemService("activity");
            if (manager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != currentPid) continue;
                if (processInfo.processName.equalsIgnoreCase(adjustConfig.processName)) break;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", processInfo.processName);
                return null;
            }
        }
        ActivityHandler activityHandler = new ActivityHandler(adjustConfig);
        return activityHandler;
    }

    @Override
    public void trackSubsessionStart() {
        Message message = Message.obtain();
        message.arg1 = 72632;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public void trackSubsessionEnd() {
        Message message = Message.obtain();
        message.arg1 = 72633;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public void trackEvent(AdjustEvent event) {
        Message message = Message.obtain();
        message.arg1 = 72634;
        message.obj = event;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public void finishedTrackingActivity(JSONObject jsonResponse) {
        if (jsonResponse == null) {
            return;
        }
        Message message = Message.obtain();
        message.arg1 = 72635;
        message.obj = jsonResponse;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            if (enabled) {
                this.logger.debug("Adjust already enabled", new Object[0]);
            } else {
                this.logger.debug("Adjust already disabled", new Object[0]);
            }
            return;
        }
        this.enabled = enabled;
        if (this.activityState != null) {
            this.activityState.enabled = enabled;
            this.writeActivityState();
        }
        if (enabled) {
            if (this.toPause()) {
                this.logger.info("Package and attribution handler remain paused due to the SDK is offline", new Object[0]);
            } else {
                this.logger.info("Resuming package handler and attribution handler to enabled the SDK", new Object[0]);
            }
            this.trackSubsessionStart();
        } else {
            this.logger.info("Pausing package handler and attribution handler to disable the SDK", new Object[0]);
            this.trackSubsessionEnd();
        }
    }

    @Override
    public void setOfflineMode(boolean offline) {
        if (offline == this.offline) {
            if (offline) {
                this.logger.debug("Adjust already in offline mode", new Object[0]);
            } else {
                this.logger.debug("Adjust already in online mode", new Object[0]);
            }
            return;
        }
        this.offline = offline;
        if (offline) {
            this.logger.info("Pausing package and attribution handler to put in offline mode", new Object[0]);
        } else if (this.toPause()) {
            this.logger.info("Package and attribution handler remain paused because the SDK is disabled", new Object[0]);
        } else {
            this.logger.info("Resuming package handler and attribution handler to put in online mode", new Object[0]);
        }
        this.updateStatus();
    }

    @Override
    public boolean isEnabled() {
        if (this.activityState != null) {
            return this.activityState.enabled;
        }
        return this.enabled;
    }

    @Override
    public void readOpenUrl(Uri url, long clickTime) {
        Message message = Message.obtain();
        message.arg1 = 72636;
        UrlClickTime urlClickTime = new UrlClickTime(url, clickTime);
        message.obj = urlClickTime;
        this.sessionHandler.sendMessage(message);
    }

    @Override
    public boolean tryUpdateAttribution(AdjustAttribution attribution) {
        if (attribution == null) {
            return false;
        }
        if (attribution.equals(this.attribution)) {
            return false;
        }
        this.saveAttribution(attribution);
        this.launchAttributionListener();
        return true;
    }

    private void saveAttribution(AdjustAttribution attribution) {
        this.attribution = attribution;
        this.writeAttribution();
    }

    private void launchAttributionListener() {
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post(runnable);
    }

    @Override
    public void setAskingAttribution(boolean askingAttribution) {
        this.activityState.askingAttribution = askingAttribution;
        this.writeActivityState();
    }

    @Override
    public ActivityPackage getAttributionPackage() {
        long now = System.currentTimeMillis();
        PackageBuilder attributionBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        return attributionBuilder.buildAttributionPackage();
    }

    @Override
    public void sendReferrer(String referrer, long clickTime) {
        Message message = Message.obtain();
        message.arg1 = 72637;
        ReferrerClickTime referrerClickTime = new ReferrerClickTime(referrer, clickTime);
        message.obj = referrerClickTime;
        this.sessionHandler.sendMessage(message);
    }

    private void updateStatus() {
        Message message = Message.obtain();
        message.arg1 = 72638;
        this.sessionHandler.sendMessage(message);
    }

    private void initInternal() {
        String playAdId;
        TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        TIMER_START = AdjustFactory.getTimerStart();
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        this.deviceInfo = new DeviceInfo(this.adjustConfig.context, this.adjustConfig.sdkPrefix);
        if ("production".equals(this.adjustConfig.environment)) {
            this.logger.setLogLevel(LogLevel.ASSERT);
        } else {
            this.logger.setLogLevel(this.adjustConfig.logLevel);
        }
        if (this.adjustConfig.eventBufferingEnabled.booleanValue()) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
        if ((playAdId = Util.getPlayAdId(this.adjustConfig.context)) == null) {
            this.logger.info("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
        }
        if (this.adjustConfig.defaultTracker != null) {
            this.logger.info("Default tracker: '%s'", this.adjustConfig.defaultTracker);
        }
        if (this.adjustConfig.referrer != null) {
            this.sendReferrer(this.adjustConfig.referrer, this.adjustConfig.referrerClickTime);
        }
        this.readAttribution();
        this.readActivityState();
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.adjustConfig.context, this.toPause());
        this.startInternal();
    }

    private void startInternal() {
        if (this.activityState != null && !this.activityState.enabled) {
            return;
        }
        this.updateStatusInternal();
        this.processSession();
        this.checkAttributionState();
        this.startTimer();
    }

    private void processSession() {
        long now = System.currentTimeMillis();
        if (this.activityState == null) {
            this.activityState = new ActivityState();
            this.activityState.sessionCount = 1;
            this.transferSessionPackage(now);
            this.activityState.resetSessionAttributes(now);
            this.activityState.enabled = this.enabled;
            this.writeActivityState();
            return;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            this.writeActivityState();
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            ++this.activityState.sessionCount;
            this.activityState.lastInterval = lastInterval;
            this.transferSessionPackage(now);
            this.activityState.resetSessionAttributes(now);
            this.writeActivityState();
            return;
        }
        if (lastInterval > SUBSESSION_INTERVAL) {
            ++this.activityState.subsessionCount;
            this.activityState.sessionLength += lastInterval;
            this.activityState.lastActivity = now;
            this.writeActivityState();
            this.logger.info("Started subsession %d of session %d", this.activityState.subsessionCount, this.activityState.sessionCount);
        }
    }

    private void checkAttributionState() {
        if (this.activityState.subsessionCount <= 1) {
            return;
        }
        if (this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.getAttributionHandler().getAttribution();
    }

    private void endInternal() {
        this.packageHandler.pauseSending();
        this.getAttributionHandler().pauseSending();
        this.stopTimer();
        if (this.updateActivityState(System.currentTimeMillis())) {
            this.writeActivityState();
        }
    }

    private void trackEventInternal(AdjustEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.checkEvent(event)) {
            return;
        }
        long now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityState(now);
        PackageBuilder eventBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage eventPackage = eventBuilder.buildEventPackage(event);
        this.packageHandler.addPackage(eventPackage);
        if (this.adjustConfig.eventBufferingEnabled.booleanValue()) {
            this.logger.info("Buffered event %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        this.writeActivityState();
    }

    private void finishedTrackingActivityInternal(JSONObject jsonResponse) {
        if (jsonResponse == null) {
            return;
        }
        String deeplink = jsonResponse.optString("deeplink", null);
        this.launchDeeplinkMain(deeplink);
        this.getAttributionHandler().checkAttribution(jsonResponse);
    }

    private void sendReferrerInternal(String referrer, long clickTime) {
        ActivityPackage clickPackage = this.buildQueryStringClickPackage(referrer, "reftag", clickTime);
        if (clickPackage == null) {
            return;
        }
        this.getAttributionHandler().getAttribution();
        this.packageHandler.sendClickPackage(clickPackage);
    }

    private void readOpenUrlInternal(Uri url, long clickTime) {
        if (url == null) {
            return;
        }
        String queryString = url.getQuery();
        ActivityPackage clickPackage = this.buildQueryStringClickPackage(queryString, "deeplink", clickTime);
        if (clickPackage == null) {
            return;
        }
        this.getAttributionHandler().getAttribution();
        this.packageHandler.sendClickPackage(clickPackage);
    }

    private ActivityPackage buildQueryStringClickPackage(String queryString, String source, long clickTime) {
        String[] queryPairs;
        if (queryString == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        LinkedHashMap<String, String> queryStringParameters = new LinkedHashMap<String, String>();
        AdjustAttribution queryStringAttribution = new AdjustAttribution();
        boolean hasAdjustTags = false;
        for (String pair : queryPairs = queryString.split("&")) {
            if (!this.readQueryString(pair, queryStringParameters, queryStringAttribution)) continue;
            hasAdjustTags = true;
        }
        if (!hasAdjustTags) {
            return null;
        }
        String reftag = (String)queryStringParameters.remove("reftag");
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        builder.extraParameters = queryStringParameters;
        builder.attribution = queryStringAttribution;
        builder.reftag = reftag;
        ActivityPackage clickPackage = builder.buildClickPackage(source, clickTime);
        return clickPackage;
    }

    private boolean readQueryString(String queryString, Map<String, String> extraParameters, AdjustAttribution queryStringAttribution) {
        String[] pairComponents = queryString.split("=");
        if (pairComponents.length != 2) {
            return false;
        }
        String key = pairComponents[0];
        if (!key.startsWith(ADJUST_PREFIX)) {
            return false;
        }
        String value = pairComponents[1];
        if (value.length() == 0) {
            return false;
        }
        String keyWOutPrefix = key.substring(ADJUST_PREFIX.length());
        if (keyWOutPrefix.length() == 0) {
            return false;
        }
        if (!this.trySetAttribution(queryStringAttribution, keyWOutPrefix, value)) {
            extraParameters.put(keyWOutPrefix, value);
        }
        return true;
    }

    private boolean trySetAttribution(AdjustAttribution queryStringAttribution, String key, String value) {
        if (key.equals("tracker")) {
            queryStringAttribution.trackerName = value;
            return true;
        }
        if (key.equals("campaign")) {
            queryStringAttribution.campaign = value;
            return true;
        }
        if (key.equals("adgroup")) {
            queryStringAttribution.adgroup = value;
            return true;
        }
        if (key.equals("creative")) {
            queryStringAttribution.creative = value;
            return true;
        }
        return false;
    }

    private void updateStatusInternal() {
        this.updateAttributionHandlerStatus();
        this.updatePackageHandlerStatus();
    }

    private void updateAttributionHandlerStatus() {
        if (this.attributionHandler == null) {
            return;
        }
        if (this.toPause()) {
            this.attributionHandler.pauseSending();
        } else {
            this.attributionHandler.resumeSending();
        }
    }

    private void updatePackageHandlerStatus() {
        if (this.packageHandler == null) {
            return;
        }
        if (this.toPause()) {
            this.packageHandler.pauseSending();
        } else {
            this.packageHandler.resumeSending();
        }
    }

    private void launchDeeplinkMain(String deeplink) {
        boolean isIntentSafe;
        if (deeplink == null) {
            return;
        }
        Uri location = Uri.parse((String)deeplink);
        Intent mapIntent = new Intent("android.intent.action.VIEW", location);
        mapIntent.setFlags(0x10000000);
        PackageManager packageManager = this.adjustConfig.context.getPackageManager();
        List activities = packageManager.queryIntentActivities(mapIntent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (!isIntentSafe) {
            this.logger.error("Unable to open deep link (%s)", deeplink);
            return;
        }
        this.logger.info("Open deep link (%s)", deeplink);
        this.adjustConfig.context.startActivity(mapIntent);
    }

    private boolean updateActivityState(long now) {
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval > SESSION_INTERVAL) {
            return false;
        }
        this.activityState.lastActivity = now;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            this.activityState.sessionLength += lastInterval;
            this.activityState.timeSpent += lastInterval;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    private void transferSessionPackage(long now) {
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage sessionPackage = builder.buildSessionPackage();
        this.packageHandler.addPackage(sessionPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void startTimer() {
        this.stopTimer();
        if (!this.activityState.enabled) {
            return;
        }
        timer = Executors.newSingleThreadScheduledExecutor();
        timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.timerFired();
            }
        }, TIMER_START, TIMER_INTERVAL, TimeUnit.MILLISECONDS);
    }

    private void stopTimer() {
        if (timer != null) {
            timer.shutdown();
            timer = null;
        }
    }

    private void timerFired() {
        if (!this.activityState.enabled) {
            this.stopTimer();
            return;
        }
        this.packageHandler.sendFirstPackage();
        if (this.updateActivityState(System.currentTimeMillis())) {
            this.writeActivityState();
        }
    }

    private void readActivityState() {
        this.activityState = (ActivityState)Util.readObject(this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
    }

    private void readAttribution() {
        this.attribution = (AdjustAttribution)Util.readObject(this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
    }

    private void writeActivityState() {
        Util.writeObject(this.activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
    }

    private void writeAttribution() {
        Util.writeObject(this.attribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
    }

    private boolean checkEvent(AdjustEvent event) {
        if (event == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!event.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private IAttributionHandler getAttributionHandler() {
        if (this.attributionHandler == null) {
            ActivityPackage attributionPackage = this.getAttributionPackage();
            this.attributionHandler = AdjustFactory.getAttributionHandler(this, attributionPackage, this.toPause(), this.adjustConfig.hasListener());
        }
        return this.attributionHandler;
    }

    private boolean toPause() {
        return this.offline || !this.isEnabled();
    }

    private static final class SessionHandler
    extends Handler {
        private static final int BASE_ADDRESS = 72630;
        private static final int INIT = 72631;
        private static final int START = 72632;
        private static final int END = 72633;
        private static final int EVENT = 72634;
        private static final int FINISH_TRACKING = 72635;
        private static final int DEEP_LINK = 72636;
        private static final int SEND_REFERRER = 72637;
        private static final int UPDATE_STATUS = 72638;
        private final WeakReference<ActivityHandler> sessionHandlerReference;

        protected SessionHandler(Looper looper, ActivityHandler sessionHandler) {
            super(looper);
            this.sessionHandlerReference = new WeakReference<ActivityHandler>(sessionHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            ActivityHandler sessionHandler = (ActivityHandler)this.sessionHandlerReference.get();
            if (sessionHandler == null) {
                return;
            }
            switch (message.arg1) {
                case 72631: {
                    sessionHandler.initInternal();
                    break;
                }
                case 72632: {
                    sessionHandler.startInternal();
                    break;
                }
                case 72633: {
                    sessionHandler.endInternal();
                    break;
                }
                case 72634: {
                    AdjustEvent event = (AdjustEvent)message.obj;
                    sessionHandler.trackEventInternal(event);
                    break;
                }
                case 72635: {
                    JSONObject jsonResponse = (JSONObject)message.obj;
                    sessionHandler.finishedTrackingActivityInternal(jsonResponse);
                    break;
                }
                case 72636: {
                    UrlClickTime urlClickTime = (UrlClickTime)message.obj;
                    sessionHandler.readOpenUrlInternal(urlClickTime.url, urlClickTime.clickTime);
                    break;
                }
                case 72637: {
                    ReferrerClickTime referrerClickTime = (ReferrerClickTime)message.obj;
                    sessionHandler.sendReferrerInternal(referrerClickTime.referrer, referrerClickTime.clickTime);
                    break;
                }
                case 72638: {
                    sessionHandler.updateStatusInternal();
                }
            }
        }
    }

    private class ReferrerClickTime {
        String referrer;
        long clickTime;

        ReferrerClickTime(String referrer, long clickTime) {
            this.referrer = referrer;
            this.clickTime = clickTime;
        }
    }

    private class UrlClickTime {
        Uri url;
        long clickTime;

        UrlClickTime(Uri url, long clickTime) {
            this.url = url;
            this.clickTime = clickTime;
        }
    }
}

