/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Reflection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static SimpleDateFormat dateFormat;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";

    protected static String createUuid() {
        return UUID.randomUUID().toString();
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return String.format("'%s'", string);
    }

    public static String dateFormat(long date) {
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        }
        return dateFormat.format(date);
    }

    public static String getPlayAdId(Context context) {
        return Reflection.getPlayAdId(context);
    }

    public static Boolean isPlayTrackingEnabled(Context context) {
        return Reflection.isPlayTrackingEnabled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(Context context, String filename, String objectName) {
        ILogger logger = AdjustFactory.getLogger();
        try {
            FileInputStream inputStream = context.openFileInput(filename);
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
            try {
                Object t = objectStream.readObject();
                logger.debug("Read %s: %s", objectName, t);
                Object object = t;
                return (T)object;
            }
            catch (ClassNotFoundException e) {
                logger.error("Failed to find %s class", objectName);
                return null;
            }
            catch (OptionalDataException e) {
                return null;
            }
            catch (IOException e) {
                logger.error("Failed to read %s object", objectName);
                return null;
            }
            catch (ClassCastException e) {
                logger.error("Failed to cast %s object", objectName);
                return null;
            }
            finally {
                objectStream.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.verbose("%s file not found", objectName);
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to open %s file for reading (%s)", objectName, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeObject(T object, Context context, String filename, String objectName) {
        ILogger logger = AdjustFactory.getLogger();
        try {
            FileOutputStream outputStream = context.openFileOutput(filename, 0);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
            try {
                objectStream.writeObject(object);
                logger.debug("Wrote %s: %s", objectName, object);
            }
            catch (NotSerializableException e) {
                logger.error("Failed to serialize %s", objectName);
            }
            finally {
                objectStream.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to open %s for writing (%s)", objectName, e);
        }
    }

    public static String parseResponse(HttpResponse httpResponse, ILogger logger) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpResponse.getEntity().writeTo((OutputStream)out);
            out.close();
            String response = out.toString().trim();
            logger.verbose("Response: %s", response);
            return response;
        }
        catch (Exception e) {
            logger.error("Failed to parse response (%s)", e);
            return null;
        }
    }

    public static JSONObject parseJsonResponse(HttpResponse httpResponse, ILogger logger) {
        if (httpResponse == null) {
            return null;
        }
        String stringResponse = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpResponse.getEntity().writeTo((OutputStream)out);
            out.close();
            stringResponse = out.toString().trim();
        }
        catch (Exception e) {
            logger.error("Failed to parse response (%s)", e.getMessage());
        }
        logger.verbose("Response: %s", stringResponse);
        if (stringResponse == null) {
            return null;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(stringResponse);
        }
        catch (JSONException e) {
            logger.error("Failed to parse json response: %s (%s)", stringResponse, e.getMessage());
        }
        if (jsonResponse == null) {
            return null;
        }
        String message = jsonResponse.optString("message", null);
        if (message == null) {
            message = "No message found";
        }
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            logger.info("%s", message);
        } else {
            logger.error("%s", message);
        }
        return jsonResponse;
    }

    public static HttpClient getHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)60000);
        return AdjustFactory.getHttpClient((HttpParams)httpParams);
    }

    public static boolean checkPermission(Context context, String permission2) {
        int result = context.checkCallingOrSelfPermission(permission2);
        return result == 0;
    }
}

