/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Map;

class DeviceInfo {
    String macSha1;
    String macShortMd5;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    Map<String, String> pluginKeys;

    DeviceInfo(Context context, String sdkPrefix) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = configuration.locale;
        int screenLayout = configuration.screenLayout;
        boolean isGooglePlayServicesAvailable = Reflection.isGooglePlayServicesAvailable(context);
        String macAddress = this.getMacAddress(context, isGooglePlayServicesAvailable);
        this.packageName = this.getPackageName(context);
        this.appVersion = this.getAppVersion(context);
        this.deviceType = this.getDeviceType(screenLayout);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(screenLayout);
        this.screenFormat = this.getScreenFormat(screenLayout);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(sdkPrefix);
        this.androidId = this.getAndroidId(context, isGooglePlayServicesAvailable);
        this.fbAttributionId = this.getFacebookAttributionId(context);
        this.pluginKeys = Reflection.getPluginKeys(context);
        this.macSha1 = this.getMacSha1(macAddress);
        this.macShortMd5 = this.getMacShortMd5(macAddress);
    }

    private String getMacAddress(Context context, boolean isGooglePlayServicesAvailable) {
        if (!isGooglePlayServicesAvailable) {
            if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                AdjustFactory.getLogger().warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
            }
            return Reflection.getMacAddress(context);
        }
        return null;
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private String getAppVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = packageManager.getPackageInfo(name, 0);
            return info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private String getDeviceType(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return null;
    }

    private String getDeviceName() {
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        return "android";
    }

    private String getOsVersion() {
        this.osVersion = "" + Build.VERSION.SDK_INT;
        return this.osVersion;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return null;
    }

    private String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return null;
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (0 == density) {
            return null;
        }
        if (density < low) {
            return "low";
        }
        if (density > high) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String sdkPrefix) {
        if (sdkPrefix == null) {
            return "android4.0.0";
        }
        return String.format("%s@%s", sdkPrefix, "android4.0.0");
    }

    private String getMacSha1(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macSha1 = this.sha1(macAddress);
        return macSha1;
    }

    private String getMacShortMd5(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macShort = macAddress.replaceAll(":", "");
        String macShortMd5 = this.md5(macShort);
        return macShortMd5;
    }

    private String getAndroidId(Context context, boolean isGooglePlayServicesAvailable) {
        if (!isGooglePlayServicesAvailable) {
            return Reflection.getAndroidId(context);
        }
        return null;
    }

    private String sha1(String text) {
        return this.hash(text, "SHA-1");
    }

    private String md5(String text) {
        return this.hash(text, "MD5");
    }

    private String hash(String text, String method) {
        String hashString = null;
        try {
            byte[] bytes = text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            hashString = DeviceInfo.convertToHex(hash);
        }
        catch (Exception e) {
            // empty catch block
        }
        return hashString;
    }

    private static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return String.format(formatString, bigInt);
    }

    private String getFacebookAttributionId(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (null == cursor) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }
}

