/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;

public class ActivityState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9039439291143138148L;
    private transient String readErrorMessage = "Unable to read '%s' field in migration device with message (%s)";
    private transient ILogger logger = AdjustFactory.getLogger();
    protected String uuid = Util.createUuid();
    protected boolean enabled = true;
    protected boolean askingAttribution = false;
    protected int eventCount = 0;
    protected int sessionCount = 0;
    protected int subsessionCount = -1;
    protected long sessionLength = -1L;
    protected long timeSpent = -1L;
    protected long lastActivity = -1L;
    protected long lastInterval = -1L;

    protected ActivityState() {
    }

    protected void resetSessionAttributes(long now) {
        this.subsessionCount = 1;
        this.sessionLength = 0L;
        this.timeSpent = 0L;
        this.lastActivity = now;
        this.lastInterval = -1L;
    }

    public String toString() {
        return String.format(Locale.US, "ec:%d sc:%d ssc:%d sl:%.1f ts:%.1f la:%s uuid:%s", this.eventCount, this.sessionCount, this.subsessionCount, (double)this.sessionLength / 1000.0, (double)this.timeSpent / 1000.0, ActivityState.stamp(this.lastActivity), this.uuid);
    }

    public ActivityState clone() {
        try {
            return (ActivityState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.eventCount = this.readIntField(fields, "eventCount", 0);
        this.sessionCount = this.readIntField(fields, "sessionCount", 0);
        this.subsessionCount = this.readIntField(fields, "subsessionCount", -1);
        this.sessionLength = this.readLongField(fields, "sessionLength", -1L);
        this.timeSpent = this.readLongField(fields, "timeSpent", -1L);
        this.lastActivity = this.readLongField(fields, "lastActivity", -1L);
        this.lastInterval = this.readLongField(fields, "lastInterval", -1L);
        this.uuid = this.readStringField(fields, "uuid", null);
        this.enabled = this.readBooleanField(fields, "enabled", true);
        this.askingAttribution = this.readBooleanField(fields, "askingAttribution", false);
        if (this.uuid == null) {
            this.uuid = Util.createUuid();
        }
    }

    private String readStringField(ObjectInputStream.GetField fields, String name, String defaultValue) {
        try {
            return (String)fields.get(name, defaultValue);
        }
        catch (Exception e) {
            this.logger.debug(this.readErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    private boolean readBooleanField(ObjectInputStream.GetField fields, String name, boolean defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            this.logger.debug(this.readErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    private int readIntField(ObjectInputStream.GetField fields, String name, int defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            this.logger.debug(this.readErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    private long readLongField(ObjectInputStream.GetField fields, String name, long defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            this.logger.debug(this.readErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    private static String stamp(long dateMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateMillis);
        Object[] objectArray = new Object[3];
        objectArray[0] = 11;
        objectArray[1] = 12;
        objectArray[2] = 13;
        return String.format(Locale.US, "%02d:%02d:%02d", objectArray);
    }
}

