/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.text.TextUtils;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class ResponseData {
    private ActivityKind activityKind = ActivityKind.UNKNOWN;
    private boolean success;
    private boolean willRetry;
    private String error;
    private String trackerToken;
    private String trackerName;
    private String network;
    private String campaign;
    private String adgroup;
    private String creative;

    public ActivityKind getActivityKind() {
        return this.activityKind;
    }

    public String getActivityKindString() {
        return this.activityKind.toString();
    }

    public boolean wasSuccess() {
        return this.success;
    }

    public boolean willRetry() {
        return this.willRetry;
    }

    public String getError() {
        return this.error;
    }

    public String getTrackerToken() {
        return this.trackerToken;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getAdgroup() {
        return this.adgroup;
    }

    public String getCreative() {
        return this.creative;
    }

    public static ResponseData fromJson(JSONObject jsonObject, String jsonString) {
        if (jsonObject == null) {
            String error = String.format("Failed to parse json response: %s", jsonString.trim());
            return ResponseData.fromError(error);
        }
        ResponseData data = new ResponseData();
        data.error = jsonObject.optString("error", null);
        data.trackerToken = jsonObject.optString("tracker_token", null);
        data.trackerName = jsonObject.optString("tracker_name", null);
        data.network = jsonObject.optString("network", null);
        data.campaign = jsonObject.optString("campaign", null);
        data.adgroup = jsonObject.optString("adgroup", null);
        data.creative = jsonObject.optString("creative", null);
        return data;
    }

    public static ResponseData fromError(String error) {
        ResponseData data = new ResponseData();
        data.error = error;
        return data;
    }

    public String toString() {
        return String.format(Locale.US, "[kind:%s success:%b willRetry:%b error:%s trackerToken:%s trackerName:%s network:%s campaign:%s adgroup:%s creative:%s]", this.getActivityKindString(), this.success, this.willRetry, Util.quote(this.error), this.trackerToken, Util.quote(this.trackerName), Util.quote(this.network), Util.quote(this.campaign), Util.quote(this.adgroup), Util.quote(this.creative));
    }

    public void setActivityKind(ActivityKind activityKind) {
        this.activityKind = activityKind;
    }

    public void setWasSuccess(boolean success) {
        this.success = success;
    }

    public void setWillRetry(boolean willRetry) {
        this.willRetry = willRetry;
    }

    public Map<String, String> toDic() {
        HashMap<String, String> responseDataDic = new HashMap<String, String>();
        responseDataDic.put("activityKind", this.activityKind.toString());
        responseDataDic.put("success", this.success ? "true" : "false");
        responseDataDic.put("willRetry", this.willRetry ? "true" : "false");
        if (!TextUtils.isEmpty((CharSequence)this.error)) {
            responseDataDic.put("error", this.error);
        }
        if (!TextUtils.isEmpty((CharSequence)this.trackerToken)) {
            responseDataDic.put("trackerToken", this.trackerToken);
        }
        if (!TextUtils.isEmpty((CharSequence)this.trackerName)) {
            responseDataDic.put("trackerName", this.trackerName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.network)) {
            responseDataDic.put("network", this.network);
        }
        if (!TextUtils.isEmpty((CharSequence)this.campaign)) {
            responseDataDic.put("campaign", this.campaign);
        }
        if (!TextUtils.isEmpty((CharSequence)this.adgroup)) {
            responseDataDic.put("adgroup", this.adgroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.creative)) {
            responseDataDic.put("creative", this.creative);
        }
        return responseDataDic;
    }
}

