/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.Logger;
import com.adjust.sdk.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class PackageBuilder {
    private Context context;
    private String appToken;
    private String macSha1;
    private String macShortMd5;
    private String androidId;
    private String fbAttributionId;
    private String userAgent;
    private String clientSdk;
    private String uuid;
    private String environment;
    private Map<String, String> pluginsKeys;
    private int sessionCount;
    private int subsessionCount;
    private long createdAt;
    private long sessionLength;
    private long timeSpent;
    private long lastInterval;
    private String defaultTracker;
    private String referrer;
    private int eventCount;
    private String eventToken;
    private double amountInCents;
    private Map<String, String> callbackParameters;
    private Map<String, String> deepLinkParameters;

    public PackageBuilder(Context context) {
        this.context = context;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setMacSha1(String macSha1) {
        this.macSha1 = macSha1;
    }

    public void setMacShortMd5(String macShortMd5) {
        this.macShortMd5 = macShortMd5;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setFbAttributionId(String fbAttributionId) {
        this.fbAttributionId = fbAttributionId;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setClientSdk(String clientSdk) {
        this.clientSdk = clientSdk;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public void setSubsessionCount(int subsessionCount) {
        this.subsessionCount = subsessionCount;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setSessionLength(long sessionLength) {
        this.sessionLength = sessionLength;
    }

    public void setTimeSpent(long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public void setLastInterval(long lastInterval) {
        this.lastInterval = lastInterval;
    }

    public void setDefaultTracker(String defaultTracker) {
        this.defaultTracker = defaultTracker;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public String getEventToken() {
        return this.eventToken;
    }

    public void setEventToken(String eventToken) {
        this.eventToken = eventToken;
    }

    public double getAmountInCents() {
        return this.amountInCents;
    }

    public void setAmountInCents(double amountInCents) {
        this.amountInCents = amountInCents;
    }

    public void setCallbackParameters(Map<String, String> callbackParameters) {
        this.callbackParameters = callbackParameters;
    }

    public void setDeepLinkParameters(Map<String, String> deepLinkParameters) {
        this.deepLinkParameters = deepLinkParameters;
    }

    public void setPluginKeys(Map<String, String> pluginKeys) {
        this.pluginsKeys = pluginKeys;
    }

    public boolean isValidForEvent() {
        if (null == this.eventToken) {
            Logger logger = AdjustFactory.getLogger();
            logger.error("Missing Event Token", new Object[0]);
            return false;
        }
        return this.isEventTokenValid();
    }

    public boolean isValidForRevenue() {
        if (this.amountInCents < 0.0) {
            Logger logger = AdjustFactory.getLogger();
            logger.error("Invalid amount %f", this.amountInCents);
            return false;
        }
        if (this.eventToken == null) {
            return true;
        }
        return this.isEventTokenValid();
    }

    public ActivityPackage buildSessionPackage() {
        Map<String, String> parameters = this.getDefaultParameters();
        this.addDuration(parameters, "last_interval", this.lastInterval);
        this.addString(parameters, "default_tracker", this.defaultTracker);
        this.addString(parameters, "referrer", this.referrer);
        ActivityPackage sessionPackage = this.getDefaultActivityPackage();
        sessionPackage.setPath("/startup");
        sessionPackage.setActivityKind(ActivityKind.SESSION);
        sessionPackage.setSuffix("");
        sessionPackage.setParameters(parameters);
        return sessionPackage;
    }

    public ActivityPackage buildEventPackage() {
        Map<String, String> parameters = this.getDefaultParameters();
        this.injectEventParameters(parameters);
        ActivityPackage eventPackage = this.getDefaultActivityPackage();
        eventPackage.setPath("/event");
        eventPackage.setActivityKind(ActivityKind.EVENT);
        eventPackage.setSuffix(this.getEventSuffix());
        eventPackage.setParameters(parameters);
        return eventPackage;
    }

    public ActivityPackage buildRevenuePackage() {
        Map<String, String> parameters = this.getDefaultParameters();
        this.injectEventParameters(parameters);
        this.addString(parameters, "amount", this.getAmountString());
        ActivityPackage revenuePackage = this.getDefaultActivityPackage();
        revenuePackage.setPath("/revenue");
        revenuePackage.setActivityKind(ActivityKind.REVENUE);
        revenuePackage.setSuffix(this.getRevenueSuffix());
        revenuePackage.setParameters(parameters);
        return revenuePackage;
    }

    public ActivityPackage buildReattributionPackage() {
        Map<String, String> parameters = this.getDefaultParameters();
        this.addMapJson(parameters, "deeplink_parameters", this.deepLinkParameters);
        ActivityPackage reattributionPackage = this.getDefaultActivityPackage();
        reattributionPackage.setPath("/reattribute");
        reattributionPackage.setActivityKind(ActivityKind.REATTRIBUTION);
        reattributionPackage.setSuffix("");
        reattributionPackage.setParameters(parameters);
        return reattributionPackage;
    }

    private boolean isEventTokenValid() {
        if (6 != this.eventToken.length()) {
            Logger logger = AdjustFactory.getLogger();
            logger.error("Malformed Event Token '%s'", this.eventToken);
            return false;
        }
        return true;
    }

    private ActivityPackage getDefaultActivityPackage() {
        ActivityPackage activityPackage = new ActivityPackage();
        activityPackage.setUserAgent(this.userAgent);
        activityPackage.setClientSdk(this.clientSdk);
        return activityPackage;
    }

    private Map<String, String> getDefaultParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addDate(parameters, "created_at", this.createdAt);
        this.addString(parameters, "app_token", this.appToken);
        this.addString(parameters, "mac_sha1", this.macSha1);
        this.addString(parameters, "mac_md5", this.macShortMd5);
        this.addString(parameters, "android_id", this.androidId);
        this.addString(parameters, "android_uuid", this.uuid);
        this.addString(parameters, "fb_id", this.fbAttributionId);
        this.addString(parameters, "environment", this.environment);
        String playAdId = Util.getPlayAdId(this.context);
        this.addString(parameters, "gps_adid", playAdId);
        Boolean isTrackingEnabled = Util.isPlayTrackingEnabled(this.context);
        this.addBoolean(parameters, "tracking_enabled", isTrackingEnabled);
        this.fillPluginKeys(parameters);
        this.checkDeviceIds(parameters);
        this.addInt(parameters, "session_count", this.sessionCount);
        this.addInt(parameters, "subsession_count", this.subsessionCount);
        this.addDuration(parameters, "session_length", this.sessionLength);
        this.addDuration(parameters, "time_spent", this.timeSpent);
        return parameters;
    }

    private void checkDeviceIds(Map<String, String> parameters) {
        if (!(parameters.containsKey("mac_sha1") || parameters.containsKey("mac_md5") || parameters.containsKey("android_id") || parameters.containsKey("gps_adid"))) {
            Logger logger = AdjustFactory.getLogger();
            logger.error("Missing device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
        }
    }

    private void fillPluginKeys(Map<String, String> parameters) {
        if (this.pluginsKeys == null) {
            return;
        }
        for (Map.Entry<String, String> pluginEntry : this.pluginsKeys.entrySet()) {
            this.addString(parameters, pluginEntry.getKey(), pluginEntry.getValue());
        }
    }

    private void injectEventParameters(Map<String, String> parameters) {
        this.addInt(parameters, "event_count", this.eventCount);
        this.addString(parameters, "event_token", this.eventToken);
        this.addMapBase64(parameters, "params", this.callbackParameters);
    }

    private String getAmountString() {
        long amountInMillis = Math.round(10.0 * this.amountInCents);
        this.amountInCents = (double)amountInMillis / 10.0;
        return Long.toString(amountInMillis);
    }

    private String getEventSuffix() {
        return String.format(" '%s'", this.eventToken);
    }

    private String getRevenueSuffix() {
        if (this.eventToken != null) {
            return String.format(Locale.US, " (%.1f cent, '%s')", this.amountInCents, this.eventToken);
        }
        return String.format(Locale.US, " (%.1f cent)", this.amountInCents);
    }

    private void addString(Map<String, String> parameters, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        parameters.put(key, value);
    }

    private void addInt(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String valueString = Long.toString(value);
        this.addString(parameters, key, valueString);
    }

    private void addDate(Map<String, String> parameters, String key, long value) {
        if (value < 0L) {
            return;
        }
        String dateString = Util.dateFormat(value);
        this.addString(parameters, key, dateString);
    }

    private void addDuration(Map<String, String> parameters, String key, long durationInMilliSeconds) {
        if (durationInMilliSeconds < 0L) {
            return;
        }
        long durationInSeconds = (durationInMilliSeconds + 500L) / 1000L;
        this.addInt(parameters, key, durationInSeconds);
    }

    private void addMapBase64(Map<String, String> parameters, String key, Map<String, String> map) {
        if (null == map) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        byte[] jsonBytes = jsonObject.toString().getBytes();
        String encodedMap = Base64.encodeToString((byte[])jsonBytes, (int)2);
        this.addString(parameters, key, encodedMap);
    }

    private void addMapJson(Map<String, String> parameters, String key, Map<String, String> map) {
        if (null == map) {
            return;
        }
        JSONObject jsonObject = new JSONObject(map);
        String jsonString = jsonObject.toString();
        this.addString(parameters, key, jsonString);
    }

    private void addBoolean(Map<String, String> parameters, String key, Boolean value) {
        if (value == null) {
            return;
        }
        int intValue = value != false ? 1 : 0;
        this.addInt(parameters, key, intValue);
    }
}

