/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.version;

import ie.omk.smpp.Address;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.version.SMPPVersion;

public class SMPPVersion33
extends SMPPVersion {
    private static final int MAX_MSG_LENGTH = 140;

    SMPPVersion33() {
        super(51, "SMPP version 3.3");
    }

    public boolean isSupported(int commandID) {
        switch (commandID & Integer.MAX_VALUE) {
            case 9: 
            case 258: 
            case 259: {
                return false;
            }
        }
        return true;
    }

    public boolean isSupportOptionalParams() {
        return false;
    }

    public int getMaxLength(int field) {
        switch (field) {
            case 5: {
                return 140;
            }
        }
        return Integer.MAX_VALUE;
    }

    public boolean validateAddress(Address s) {
        int ton = s.getTON();
        int npi = s.getNPI();
        boolean tonValid = ton >= 0 && ton <= 255;
        boolean npiValid = npi >= 0 && npi <= 255;
        boolean addressValid = s.getAddress().length() <= 20;
        return tonValid && npiValid && addressValid;
    }

    public boolean validateEsmClass(int c) {
        return c >= 0 && c <= 255;
    }

    public boolean validateProtocolID(int id) {
        return id >= 0 && id <= 255;
    }

    public boolean validateDataCoding(int dc) {
        return dc >= 0 && dc <= 255;
    }

    public boolean validateDefaultMsg(int id) {
        return id >= 0 && id <= 255;
    }

    public boolean validateMessageText(String text, AlphabetEncoding alphabet) {
        if (text != null) {
            return alphabet.encodeString(text).length <= 140;
        }
        return true;
    }

    public boolean validateMessage(byte[] message, MessageEncoding encoding) {
        if (message != null) {
            return message.length <= 140;
        }
        return true;
    }

    public boolean validateServiceType(String type) {
        return type.length() <= 5;
    }

    public boolean validateMessageId(String id) {
        try {
            Long.parseLong(id, 16);
            return id.length() <= 8;
        }
        catch (NumberFormatException x) {
            return false;
        }
    }

    public boolean validateMessageState(int st) {
        return st >= 0 && st <= 255;
    }

    public boolean validateErrorCode(int code) {
        return code >= 0 && code <= 255;
    }

    public boolean validatePriorityFlag(int flag) {
        return flag == 0 || flag == 1;
    }

    public boolean validateRegisteredDelivery(int flag) {
        return flag == 0 || flag == 1;
    }

    public boolean validateReplaceIfPresent(int flag) {
        return flag == 0 || flag == 1;
    }

    public boolean validateNumberOfDests(int num) {
        return num >= 0 && num <= 255;
    }

    public boolean validateNumUnsuccessful(int num) {
        return num >= 0 && num <= 255;
    }

    public boolean validateDistListName(String name) {
        return name.length() <= 20;
    }

    public boolean validateSystemId(String sysId) {
        return sysId.length() <= 15;
    }

    public boolean validatePassword(String password) {
        return password.length() <= 8;
    }

    public boolean validateSystemType(String sysType) {
        return sysType.length() <= 12;
    }

    public boolean validateAddressRange(String addressRange) {
        return addressRange.length() <= 40;
    }

    public boolean validateParamName(String paramName) {
        return paramName.length() <= 31;
    }

    public boolean validateParamValue(String paramValue) {
        return paramValue.length() <= 100;
    }
}

