/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BadValueTypeException;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.InvalidSizeForValueException;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TLVTable
implements Serializable {
    static final long serialVersionUID = -4113000096792513355L;
    private Map map = new HashMap();
    private byte[] opts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(byte[] b, int offset, int len) {
        Map map = this.map;
        synchronized (map) {
            this.opts = new byte[len];
            System.arraycopy(b, offset, this.opts, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        Map map = this.map;
        synchronized (map) {
            byte[] buffer = new byte[1024];
            Iterator i = this.map.keySet().iterator();
            while (i.hasNext()) {
                Object v;
                Tag t = (Tag)i.next();
                Encoder enc = t.getEncoder();
                int l = enc.getValueLength(t, v = this.map.get(t));
                if (buffer.length < l + 4) {
                    buffer = new byte[l + 4];
                }
                SMPPIO.intToBytes(t.intValue(), 2, buffer, 0);
                SMPPIO.intToBytes(l, 2, buffer, 2);
                enc.writeTo(t, v, buffer, 4);
                out.write(buffer, 0, l + 4);
            }
        }
    }

    public Object get(Tag tag) {
        Object v = this.map.get(tag);
        if (v == null) {
            v = this.getValueFromBytes(tag);
        }
        return v;
    }

    public Object get(int tag) {
        Tag tagObj = Tag.getTag(tag);
        Object v = this.map.get(tagObj);
        if (v == null) {
            v = this.getValueFromBytes(tagObj);
        }
        return v;
    }

    public boolean isSet(Tag tag) {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        return this.map.containsKey(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(Tag tag, Object value) throws BadValueTypeException, InvalidSizeForValueException {
        Map map = this.map;
        synchronized (map) {
            boolean illegal;
            if (this.opts != null) {
                this.parseAllOpts();
            }
            if (tag.getType() == null) {
                if (value != null) {
                    throw new BadValueTypeException("Tag " + Integer.toHexString(tag.intValue()) + " does not accept a value.");
                }
            } else if (!tag.getType().isAssignableFrom(value.getClass())) {
                throw new BadValueTypeException("Tag " + Integer.toHexString(tag.intValue()) + " expects a value of type " + tag.getType());
            }
            int min = tag.getMinLength();
            int max = tag.getMaxLength();
            int actual = tag.getEncoder().getValueLength(tag, value);
            boolean bl = illegal = min > -1 && actual < min;
            if (!illegal) {
                boolean bl2 = illegal = max > -1 && actual > max;
            }
            if (illegal) {
                throw new InvalidSizeForValueException("Tag " + Integer.toHexString(tag.intValue()) + " must have a length in the range " + min + " <= len <= " + max);
            }
            return this.map.put(tag, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseAllOpts() {
        Map map = this.map;
        synchronized (map) {
            int l;
            for (int p = 0; p < this.opts.length; p += 4 + l) {
                Object val = null;
                Tag t = Tag.getTag(SMPPIO.bytesToInt(this.opts, p, 2));
                Encoder enc = t.getEncoder();
                l = SMPPIO.bytesToInt(this.opts, p + 2, 2);
                val = enc.readFrom(t, this.opts, p + 4, l);
                this.map.put(t, val);
            }
            this.opts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueFromBytes(Tag tag) {
        int l;
        if (this.opts == null || this.opts.length < 4) {
            return null;
        }
        Encoder enc = tag.getEncoder();
        Object val = null;
        int p = 0;
        do {
            int t = SMPPIO.bytesToInt(this.opts, p, 2);
            l = SMPPIO.bytesToInt(this.opts, p + 2, 2);
            if (!tag.equals(t)) continue;
            val = enc.readFrom(tag, this.opts, p + 4, l);
            Map map = this.map;
            synchronized (map) {
                this.map.put(tag, val);
                break;
            }
        } while ((p += 4 + l) < this.opts.length);
        return val;
    }

    public int getLength() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        int length = this.map.size() * 4;
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            Encoder enc = tag.getEncoder();
            length += enc.getValueLength(tag, this.map.get(tag));
        }
        return length;
    }

    public Set tagSet() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        return this.map.keySet();
    }

    public Collection values() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        return this.map.values();
    }
}

