/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BadValueTypeException;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.util.SMPPIO;

public class NumberEncoder
implements Encoder {
    public void writeTo(Tag tag, Object value, byte[] b, int offset) {
        Number num;
        long longVal = 0L;
        long mask = 0L;
        try {
            num = (Number)value;
        }
        catch (ClassCastException x) {
            throw new BadValueTypeException("Value must be of type java.lang.Number");
        }
        mask = value instanceof Byte ? 255L : (value instanceof Short ? 65535L : (value instanceof Integer ? -1L : -1L));
        longVal = num.longValue() & mask;
        SMPPIO.longToBytes(longVal, tag.getLength(), b, offset);
    }

    public Object readFrom(Tag tag, byte[] b, int offset, int length) {
        long val = SMPPIO.bytesToLong(b, offset, length);
        if (length <= 4) {
            return new Integer((int)val);
        }
        return new Long(val);
    }

    public int getValueLength(Tag tag, Object value) {
        return tag.getLength();
    }
}

