/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Bind
extends SMPPRequest {
    private String sysId;
    private String password;
    private String sysType;
    private String addressRange;
    private int addrTon;
    private int addrNpi;

    public Bind(int id) {
        super(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSystemId(String sysId) throws InvalidParameterValueException {
        if (sysId != null) {
            if (!this.version.validateSystemId(sysId)) throw new InvalidParameterValueException("Invalid system ID", sysId);
            this.sysId = sysId;
            return;
        } else {
            this.sysId = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPassword(String password) throws InvalidParameterValueException {
        if (password != null) {
            if (!this.version.validatePassword(password)) throw new InvalidParameterValueException("Invalid password", password);
            this.password = password;
            return;
        } else {
            this.password = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSystemType(String sysType) throws InvalidParameterValueException {
        if (sysType != null) {
            if (!this.version.validateSystemType(sysType)) throw new InvalidParameterValueException("Invalid system type", sysType);
            this.sysType = sysType;
            return;
        } else {
            this.sysType = null;
        }
    }

    public void setAddressTon(int addrTon) throws InvalidParameterValueException {
        this.addrTon = addrTon;
    }

    public void setAddressNpi(int addrNpi) throws InvalidParameterValueException {
        this.addrNpi = addrNpi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAddressRange(String addressRange) throws InvalidParameterValueException {
        if (addressRange != null) {
            if (!this.version.validateAddressRange(addressRange)) throw new InvalidParameterValueException("Invalid address range", addressRange);
            this.addressRange = addressRange;
            return;
        } else {
            this.addressRange = null;
        }
    }

    public String getSystemId() {
        return this.sysId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.sysType;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public int getAddressTon() {
        return this.addrTon;
    }

    public int getAddressNpi() {
        return this.addrNpi;
    }

    public int getInterfaceVersion() {
        return this.version.getVersionID();
    }

    public int getBodyLength() {
        int len = (this.sysId != null ? this.sysId.length() : 0) + (this.password != null ? this.password.length() : 0) + (this.sysType != null ? this.sysType.length() : 0) + (this.addressRange != null ? this.addressRange.length() : 0);
        return len + 3 + 4;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.sysId, out);
        SMPPIO.writeCString(this.password, out);
        SMPPIO.writeCString(this.sysType, out);
        SMPPIO.writeInt(this.version.getVersionID(), 1, out);
        SMPPIO.writeInt(this.addrTon, 1, out);
        SMPPIO.writeInt(this.addrNpi, 1, out);
        SMPPIO.writeCString(this.addressRange, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        try {
            this.sysId = SMPPIO.readCString(body, offset);
            this.password = SMPPIO.readCString(body, offset += this.sysId.length() + 1);
            this.sysType = SMPPIO.readCString(body, offset += this.password.length() + 1);
            offset += this.sysType.length() + 1;
            int interfaceVer = SMPPIO.bytesToInt(body, offset++, 1);
            this.version = SMPPVersion.getVersion(interfaceVer);
            this.addrTon = SMPPIO.bytesToInt(body, offset++, 1);
            this.addrNpi = SMPPIO.bytesToInt(body, offset++, 1);
            this.addressRange = SMPPIO.readCString(body, offset);
        }
        catch (VersionException x) {
            throw new SMPPProtocolException("Invalid interface version in response", x);
        }
    }

    public String toString() {
        return new String("bind");
    }
}

