/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.parsers;

import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import com.actionjava.mvn.plugins.assets.parsers.InstanceParser;
import com.actionjava.mvn.plugins.assets.parsers.ManifestParser;
import com.actionjava.mvn.plugins.assets.vo.Bounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymbolParser
extends InstanceParser {
    private static final String REGEX_SYMBOL_BEGIN = "^\\(lib\\.(.*)(\\s*)=(\\s*)function\\(\\)(\\s*)\\{(.*)$";
    private static final String REGEX_SYMBOL_END_1 = "this\\.addChild\\((.*);$";
    private static final String REGEX_SYMBOL_END_2 = "^\\}\\)\\.prototype(\\s*)=(\\s*)p(.*);$";
    private static final String REGEX_SYMBOL_END_3 = "^p\\.nominalBounds(.*);$";
    private static final String REGEX_INSTANCE_BEGIN = "this.([a-zA-Z0-9_]+)\\s=\\snew";
    private static final String REGEX_INSTANCE_END = "this.([a-zA-Z0-9_]+).setTransform";
    private static final String REGEX_SYMBOL_NAME = "^\\(lib\\.([a-zA-Z0-9_]+)\\s*=\\s*function\\(\\)\\s*\\{.*$";
    private static final String REGEX_SYMBOL_TYPE = "^\\}\\)\\.prototype\\s*=\\s*p\\s*=\\s*new\\s*cjs\\.(\\w+)\\(\\);$";
    private static final String REGEX_SYMBOL_BOUNDS = "^p\\.nominalBounds\\s*=\\s*new cjs\\.Rectangle\\((.*)\\);$";
    private static final String REGEX_BITMAP_BODY = "^\\s*this.initialize\\(img\\.(.*)\\);$";
    private String symbolPackage;
    private ManifestParser manifestParser;
    private Map<String, Symbol> symbols = new HashMap<String, Symbol>();

    public SymbolParser(ManifestParser manifestParser, String symbolPackage) {
        this.initialize(manifestParser, symbolPackage);
    }

    private void initialize(ManifestParser manifestParser, String symbolPackage) {
        this.manifestParser = manifestParser;
        this.symbolPackage = symbolPackage;
    }

    public Symbol[] parse(String[] symbolsRaw) {
        int beginSymbolIndex = 0;
        int endSymbolIndex = 0;
        ArrayList<String[]> symbolsScraped = new ArrayList<String[]>();
        while ((beginSymbolIndex = this.getLineNumberByRegExFromIndex(symbolsRaw, REGEX_SYMBOL_BEGIN, endSymbolIndex)) != -1 && (endSymbolIndex = this.getLineNumberByRegExFromIndex(symbolsRaw, REGEX_SYMBOL_END_3, beginSymbolIndex) + 1) != -1) {
            symbolsScraped.add(this.copyRangeFromArray(symbolsRaw, beginSymbolIndex, endSymbolIndex));
        }
        this.createReferenceList(symbolsScraped);
        for (Map.Entry<String, Symbol> pair : this.symbols.entrySet()) {
            this.parseSymbol(pair.getValue());
        }
        return this.symbols.values().toArray(new Symbol[this.symbols.size()]);
    }

    @Override
    public Symbol getSymbolByName(String name) {
        return this.symbols.get(name);
    }

    private void parseSymbol(Symbol s) {
        if (s.getType().equals("sprite")) {
            this.parseSymbolBody(s, s.getRawData());
        } else if (s.getType().equals("bitmap")) {
            this.parseBitmapBody(s, s.getRawData());
        }
    }

    private void createReferenceList(List<String[]> symbolsRaw) {
        for (int i = 0; i < symbolsRaw.size(); ++i) {
            String[] symbolRaw = symbolsRaw.get(i);
            Symbol symbol = this.createSymbolReference(symbolRaw);
            this.symbols.put(symbol.getName(), symbol);
        }
    }

    private Symbol createSymbolReference(String[] symbolRaw) {
        int symbolNameRaw = this.getLineNumberByRegEx(symbolRaw, REGEX_SYMBOL_NAME);
        int symbolTypeRaw = this.getLineNumberByRegEx(symbolRaw, REGEX_SYMBOL_TYPE);
        int symbolBoundsRaw = this.getLineNumberByRegEx(symbolRaw, REGEX_SYMBOL_BOUNDS);
        String symbolName = this.getSymbolName(symbolRaw[symbolNameRaw]);
        String symbolType = this.getSymbolType(symbolRaw[symbolTypeRaw]);
        Bounds symbolBounds = this.getSymbolBounds(symbolRaw[symbolBoundsRaw]);
        String[] symbolBody = this.getSymbolBody(symbolRaw);
        Symbol s = new Symbol(symbolName, symbolName, this.symbolPackage);
        s.setType(symbolType);
        s.setBounds(symbolBounds);
        s.setRawData(symbolBody);
        return s;
    }

    private String getSymbolName(String rawLine) {
        Pattern pattern = Pattern.compile(REGEX_SYMBOL_NAME);
        Matcher matcher = pattern.matcher(rawLine);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getSymbolType(String rawLine) {
        Pattern pattern = Pattern.compile(REGEX_SYMBOL_TYPE);
        Matcher matcher = pattern.matcher(rawLine);
        if (matcher.find()) {
            String rawType = matcher.group(1);
            if (rawType.equals("Container")) {
                return "sprite";
            }
            if (rawType.equals("Bitmap")) {
                return "bitmap";
            }
            if (rawType.equals("MovieClip")) {
                return "movieclip";
            }
        }
        return "unknown";
    }

    private Bounds getSymbolBounds(String rawLine) {
        Pattern pattern = Pattern.compile(REGEX_SYMBOL_BOUNDS);
        Matcher matcher = pattern.matcher(rawLine);
        if (matcher.find()) {
            String rawBounds = matcher.group(1);
            String[] splitRawBounds = Pattern.compile(",").split(rawBounds);
            if (splitRawBounds.length == 4) {
                Bounds b = new Bounds(Double.valueOf(splitRawBounds[0]), Double.valueOf(splitRawBounds[1]), Double.valueOf(splitRawBounds[2]), Double.valueOf(splitRawBounds[3]));
                return b;
            }
        }
        return null;
    }

    private String[] getSymbolBody(String[] rawLines) {
        ArrayList<String> newRawLines = new ArrayList<String>();
        for (int i = 0; i < rawLines.length; ++i) {
            if (!Pattern.matches("^(\\s*)this\\.(.*);$", rawLines[i]) || Pattern.matches("^(\\s*)this\\.addChild(.*);$", rawLines[i])) continue;
            newRawLines.add(rawLines[i]);
        }
        return newRawLines.toArray(new String[newRawLines.size()]);
    }

    private void parseSymbolBody(Symbol symbol, String[] symbolBodyRaw) {
        int startLine = 0;
        int endLine = 0;
        boolean lookForBegin = true;
        ArrayList<String> instanceListRaw = new ArrayList<String>();
        for (int i = 0; i < symbolBodyRaw.length; ++i) {
            Matcher matcher;
            Pattern pattern;
            String symbolBodyLineRaw = symbolBodyRaw[i];
            if (lookForBegin) {
                pattern = Pattern.compile(REGEX_INSTANCE_BEGIN);
                matcher = pattern.matcher(symbolBodyLineRaw);
                if (!matcher.find()) continue;
                startLine = i;
                lookForBegin = false;
                continue;
            }
            pattern = Pattern.compile(REGEX_INSTANCE_END);
            matcher = pattern.matcher(symbolBodyLineRaw);
            if (!matcher.find()) continue;
            endLine = i + 1;
            for (int j = startLine; j < endLine; ++j) {
                String symbolBodyLine = symbolBodyRaw[j];
                instanceListRaw.add(symbolBodyLine);
            }
            startLine = 0;
            endLine = 0;
            lookForBegin = true;
            Instance inst = this.parseInstance(instanceListRaw.toArray(new String[instanceListRaw.size()]));
            instanceListRaw.clear();
            if (inst == null) continue;
            symbol.addChild(inst);
        }
    }

    private void parseBitmapBody(Symbol symbol, String[] symbolBodyRaw) {
        for (int i = 0; i < symbolBodyRaw.length; ++i) {
            Pattern p = Pattern.compile(REGEX_BITMAP_BODY);
            Matcher m = p.matcher(symbolBodyRaw[i]);
            if (!m.find()) continue;
            String group1 = m.group(1);
            symbol.setBitmapUrl(this.manifestParser.getHrefByID(group1));
        }
    }
}

