/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.parsers;

import com.actionjava.mvn.plugins.assets.parsers.AbstractParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.FileUtils;

public class ManifestParser
extends AbstractParser {
    private static final String REGEX_MANIFEST_BEGIN = "^\\s*manifest:\\s*\\[$";
    private static final String REGEX_MANIFEST_END_1 = "^\\s*\\]\\s*$";
    private static final String REGEX_MANIFEST_END_2 = "^\\s*\\};\\s*$";
    private static final String REGEX_MANIFEST_IMG = "^\\s*\\{src:\"(.*)\", id:\"(.*)\"}";
    private Map<String, String> imgManifest = new HashMap<String, String>();
    private File baseDirectory;

    public ManifestParser(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.copyImages();
    }

    public void parse(String[] rawManifest) {
        int manifestBeginIndex = this.getLineNumberByRegEx(rawManifest, REGEX_MANIFEST_BEGIN) + 1;
        if (manifestBeginIndex != -1) {
            int manifestEndIndex1 = this.getLineNumberByRegExFromIndex(rawManifest, REGEX_MANIFEST_END_1, manifestBeginIndex);
            int manifestEndIndex2 = this.getLineNumberByRegExFromIndex(rawManifest, REGEX_MANIFEST_END_2, manifestEndIndex1) + 1;
            this.parseImgLines(this.copyRangeFromArray(rawManifest, manifestBeginIndex, manifestEndIndex1));
        }
    }

    private void parseImgLines(String[] imgLinesRaw) {
        for (int i = 0; i < imgLinesRaw.length; ++i) {
            Pattern p = Pattern.compile(REGEX_MANIFEST_IMG);
            Matcher m = p.matcher(imgLinesRaw[i]);
            if (!m.find()) continue;
            String group1 = m.group(1);
            String group2 = m.group(2);
            this.imgManifest.put(group2, group1);
        }
    }

    private void copyImages() {
        File originalImgDir = new File(this.baseDirectory.getAbsolutePath() + "//src//assets/images");
        File targetImgDir = new File(this.baseDirectory.getAbsolutePath() + "//src//main//webapp//images");
        try {
            File[] files = targetImgDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            FileUtils.copyDirectory((File)originalImgDir, (File)targetImgDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getHrefByID(String id) {
        return this.imgManifest.get(id);
    }
}

