/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.parsers;

import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.Shape;
import com.actionjava.mvn.plugins.assets.data.Sprite;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;
import com.actionjava.mvn.plugins.assets.parsers.AbstractParser;
import com.actionjava.mvn.plugins.assets.parsers.GraphicsParser;
import com.actionjava.mvn.plugins.assets.parsers.TransformParser;
import com.actionjava.mvn.plugins.assets.vo.Transform;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class InstanceParser
extends AbstractParser {
    private static final String INSTANCE_NAME = "this.([a-zA-Z0-9_]+)\\s=\\snew";
    private static final String INSTANCE_CJS = "this.([a-zA-Z0-9_]+)\\s=\\snew cjs";
    private static final String INSTANCE_LIB = "this.([a-zA-Z0-9_]+)\\s=\\snew lib\\.(.*)\\(\\);$";
    private static final String INSTANCE_GRAPHICS = "this.([a-zA-Z0-9_]+).graphics";
    private static final String INSTANCE_TRANSFORM = "this.([a-zA-Z0-9_]+).setTransform";
    private GraphicsParser graphicsParser;
    private TransformParser transformParser;

    public InstanceParser() {
        this.initialize();
    }

    private void initialize() {
        this.graphicsParser = new GraphicsParser();
        this.transformParser = new TransformParser();
    }

    public Instance parseInstance(String[] lines) {
        String nameRaw = null;
        String graphicsRaw = null;
        String transformRaw = null;
        String name = null;
        Instance instance = null;
        Object transform = null;
        Instruction[] graphics = null;
        block5: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int lineID = this.identifyLine(line);
            switch (lineID) {
                case 1: {
                    nameRaw = line;
                    continue block5;
                }
                case 2: {
                    graphicsRaw = line;
                    continue block5;
                }
                case 3: {
                    transformRaw = line;
                    continue block5;
                }
            }
        }
        if (nameRaw != null) {
            name = this.parseName(nameRaw);
            instance = graphicsRaw == null ? new Sprite(name, name, this.getSymbolByName(this.parseClassName(nameRaw))) : new Shape(name, name);
            if (transformRaw != null) {
                instance.setTransform(Transform.createNew(this.parseTransform(transformRaw)));
            }
            if (graphicsRaw != null) {
                graphics = this.parseGraphics(graphicsRaw);
                ((Shape)instance).setGraphics(graphics);
            }
            return instance;
        }
        return null;
    }

    public abstract Symbol getSymbolByName(String var1);

    private int identifyLine(String line) {
        Pattern pattern = Pattern.compile(INSTANCE_NAME, 32);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        pattern = Pattern.compile(INSTANCE_GRAPHICS, 32);
        matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 2;
        }
        pattern = Pattern.compile(INSTANCE_TRANSFORM, 32);
        matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 3;
        }
        return 0;
    }

    private String parseName(String lineRaw) {
        Pattern pattern = Pattern.compile(INSTANCE_NAME, 32);
        Matcher matcher = pattern.matcher(lineRaw);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String parseClassName(String lineRaw) {
        Pattern pattern = Pattern.compile(INSTANCE_LIB, 32);
        Matcher matcher = pattern.matcher(lineRaw);
        if (matcher.find()) {
            String s1 = matcher.group(2);
            return s1.substring(0, 1).toUpperCase() + s1.substring(1);
        }
        return null;
    }

    private Instruction[] parseGraphics(String lineRaw) {
        Pattern pattern = Pattern.compile(INSTANCE_GRAPHICS, 32);
        Matcher matcher = pattern.matcher(lineRaw);
        if (matcher.find()) {
            return this.graphicsParser.parseGraphics(lineRaw.replaceAll("^.*this.[a-zA-Z0-9_]+.graphics.", ""));
        }
        System.out.println("ERROR, THIS IS NOT A GRAPHICS LINE!!");
        return null;
    }

    private Parameter[] parseTransform(String lineRaw) {
        Pattern pattern = Pattern.compile(INSTANCE_TRANSFORM, 32);
        Matcher matcher = pattern.matcher(lineRaw);
        if (matcher.find()) {
            return this.transformParser.parseTransform(lineRaw);
        }
        System.out.println("ERROR, THIS IS NOT A TRANSFORM LINE!!");
        return null;
    }
}

