/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.parsers;

import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Shape;
import com.actionjava.mvn.plugins.assets.data.Stage;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;
import com.actionjava.mvn.plugins.assets.io.AssetReader;
import com.actionjava.mvn.plugins.assets.io.AssetWriter;
import com.actionjava.mvn.plugins.assets.parsers.AbstractParser;
import com.actionjava.mvn.plugins.assets.parsers.ManifestParser;
import com.actionjava.mvn.plugins.assets.parsers.StageParser;
import com.actionjava.mvn.plugins.assets.parsers.SymbolParser;
import com.actionjava.mvn.plugins.assets.vo.AssetSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AssetParser
extends AbstractParser {
    private static final String REGEX_MANIFEST_FLAG_1 = "^//(\\s*)library properties:(\\s*)$";
    private static final String REGEX_MANIFEST_FLAG_2 = "^lib\\.properties = \\{(\\s*)$";
    private static final String REGEX_MANIFEST_END = "^};(\\s*)$";
    private static final String REGEX_STAGE_FLAG = "^//(\\s*)stage content:(\\s*)$";
    private static final String REGEX_SYMBOL_FLAG = "^//(\\s*)symbols:(\\s*)$";
    private static final String REGEX_BEGIN = "^(lib.[\\w] = function() {";
    private static final String REGEX_END = "^\\}\\)\\.prototype(.*);$";
    private static final String REGEX_BOUNDS = "^p\\.nominalBounds(.*);$";
    private static final String REGEX_DOC_END_1 = "^\\}\\)\\(lib = lib\\|\\|\\{\\}, images = images\\|\\|\\{\\}, createjs = createjs\\|\\|\\{\\}(.*);$";
    private static final String REGEX_DOC_END_2 = "^var lib, images, createjs;$";
    private AssetReader reader;
    private AssetWriter writer;
    private ManifestParser manifestParser;
    private StageParser stageParser;
    private SymbolParser symbolParser;
    private Stage stage;
    private List<Instance> instances;
    private List<Shape> shapes;
    private List<Symbol> symbols;
    private AssetSettings settings;
    private File baseDirectory;

    public AssetParser(AssetSettings settings, File baseDirectory) {
        this.initialize(settings, baseDirectory);
    }

    private void initialize(AssetSettings assetSettings, File baseDirectory) {
        this.settings = assetSettings;
        this.baseDirectory = baseDirectory;
        this.initializeIO();
        this.initializeParsers();
        this.initializeInstances();
    }

    private void initializeIO() {
        File assetJS;
        try {
            assetJS = new File(this.settings.getAssetImportDirectory().getAbsoluteFile() + "/" + this.settings.getName() + ".js");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.reader = new AssetReader(assetJS);
        this.writer = new AssetWriter(this.settings.getAssetExportDirectory());
    }

    private void initializeParsers() {
        this.manifestParser = new ManifestParser(this.baseDirectory);
        this.symbolParser = new SymbolParser(this.manifestParser, this.settings.getAssetPackage());
        this.stageParser = new StageParser(this.symbolParser);
    }

    private void initializeInstances() {
        this.stage = new Stage(this.settings.getName(), this.settings.getName());
        this.shapes = new ArrayList<Shape>();
        this.symbols = new ArrayList<Symbol>();
        this.instances = new ArrayList<Instance>();
    }

    public void read() {
        this.reader.read();
    }

    public void parse() {
        String[] lines = this.reader.getAssetLines();
        String[] manifestRaw = this.getRawManifestData(lines);
        String[] stageRaw = this.getRawStageData(lines);
        String[] symbolsRaw = this.getRawSymbolData(lines);
        this.manifestParser.parse(manifestRaw);
        this.symbols = Arrays.asList(this.symbolParser.parse(symbolsRaw));
        this.stageParser.parse(stageRaw);
    }

    public void write() {
        this.writer.write(this.symbols);
    }

    private String[] getRawManifestData(String[] lines) {
        int manifestFlagIndex1 = this.getLineNumberByRegEx(lines, REGEX_MANIFEST_FLAG_1);
        if (manifestFlagIndex1 != -1) {
            int manifestFlagIndex2 = this.getLineNumberByRegExFromIndex(lines, REGEX_MANIFEST_FLAG_2, manifestFlagIndex1);
            int manifestEndIndex = this.getLineNumberByRegExFromIndex(lines, REGEX_MANIFEST_END, manifestFlagIndex2) + 1;
            return this.copyRangeFromArray(lines, manifestFlagIndex2, manifestEndIndex);
        }
        return null;
    }

    private String[] getRawStageData(String[] lines) {
        int stageFlagIndex = this.getLineNumberByRegEx(lines, REGEX_STAGE_FLAG) + 1;
        int stageEndIndex1 = this.getLineNumberByRegExFromIndex(lines, REGEX_END, stageFlagIndex);
        int stageEndIndex2 = this.getLineNumberByRegExFromIndex(lines, REGEX_BOUNDS, stageEndIndex1) + 1;
        return this.copyRangeFromArray(lines, stageFlagIndex, stageEndIndex2);
    }

    private String[] getRawSymbolData(String[] lines) {
        int stageFlagIndex = this.getLineNumberByRegEx(lines, REGEX_STAGE_FLAG);
        int stageEndIndex1 = this.getLineNumberByRegExFromIndex(lines, REGEX_END, stageFlagIndex);
        int stageEndIndex2 = this.getLineNumberByRegExFromIndex(lines, REGEX_BOUNDS, stageEndIndex1) + 1;
        String[] withoutStage = this.removeRangeFromArray(lines, stageFlagIndex, stageEndIndex2);
        int symbolFlagIndex = this.getLineNumberByRegEx(withoutStage, REGEX_SYMBOL_FLAG) + 1;
        int symbolEndIndex = this.getLineNumberByRegExFromIndex(withoutStage, REGEX_DOC_END_1, symbolFlagIndex);
        return this.copyRangeFromArray(withoutStage, symbolFlagIndex, symbolEndIndex);
    }

    private void logSymbol(Symbol symbol) {
        System.out.println("SYMBOL: ");
        System.out.println("id: " + symbol.getID());
        System.out.println("name: " + symbol.getName());
        System.out.println("children: " + symbol.getChildren().length);
        System.out.println("");
        this.logSymbolChildren(symbol.getChildren());
    }

    private void logSymbolChildren(Instance[] children) {
        for (int i = 0; i < children.length; ++i) {
            Instance child = children[i];
            if (child instanceof Symbol) {
                Symbol childSymbol = (Symbol)child;
                continue;
            }
            if (!(child instanceof Shape)) continue;
            Shape childShape = (Shape)child;
            this.logShape(childShape);
        }
    }

    private void logShape(Shape shape) {
        System.out.println("SHAPE: ");
        System.out.println("id: " + shape.getID());
        System.out.println("name: " + shape.getName());
        Instruction[] graphics = shape.getGraphics();
        if (graphics != null) {
            for (int i = 0; i < graphics.length; ++i) {
                Instruction inst = graphics[i];
                System.out.println(inst.toString());
            }
        }
        System.out.println("");
    }
}

