/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;

public class MoveTo
extends Instruction {
    public static final String ID = "mt";
    public static final String NAME = "moveTo";
    private double x;
    private double y;

    public MoveTo() {
        super(ID, NAME);
        this.initialize(0.0, 0.0);
    }

    public MoveTo(double x, double y) {
        super(ID, NAME);
        this.initialize(x, y);
    }

    private void initialize(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Instruction createNew(Parameter[] params) throws Exception {
        if (params.length != 2) {
            throw new Exception("Param count does not match the Instruction");
        }
        return new MoveTo(params[0].getNumberValue(), params[1].getNumberValue());
    }

    @Override
    public String toMethod() {
        return super.toMethod() + this.getMethodParams();
    }

    @Override
    public String getMethodParams() {
        String methodParams = "(";
        methodParams = methodParams + this.x + ",";
        methodParams = methodParams + this.y;
        methodParams = methodParams + ")";
        return methodParams;
    }

    @Override
    public String toString() {
        return "MoveTo [x: " + this.x + ", y: " + this.y + "]";
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

