/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;

public class DrawRoundRect
extends Instruction {
    public static final String ID = "rr";
    public static final String NAME = "drawRoundRect";
    private double x;
    private double y;
    private double width;
    private double height;
    private double radius;

    public DrawRoundRect() {
        super(ID, NAME);
        this.initialize(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public DrawRoundRect(double x, double y, double width, double height, double radius) {
        super(ID, NAME);
        this.initialize(x, y, width, height, radius);
    }

    private void initialize(double x, double y, double width, double height, double radius) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.radius = radius;
    }

    @Override
    public Instruction createNew(Parameter[] params) throws Exception {
        if (params.length != 5) {
            throw new Exception("Param count does not match the Instruction");
        }
        return new DrawRoundRect(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue());
    }

    @Override
    public String toMethod() {
        return super.toMethod() + this.getMethodParams();
    }

    @Override
    public String getMethodParams() {
        String methodParams = "(";
        methodParams = methodParams + this.x + ",";
        methodParams = methodParams + this.y + ",";
        methodParams = methodParams + this.width + ",";
        methodParams = methodParams + this.height + ",";
        methodParams = methodParams + this.radius;
        methodParams = methodParams + ")";
        return methodParams;
    }

    @Override
    public String toString() {
        return "DrawRoundRect [x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.height + ", radius: " + this.radius + "]";
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }
}

