/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;

public class CurveTo
extends Instruction {
    public static final String ID = "ct";
    public static final String NAME = "curveTo";
    private double cpx;
    private double cpy;
    private double x;
    private double y;

    public CurveTo() {
        super(ID, NAME);
        this.initialize(0.0, 0.0, 0.0, 0.0);
    }

    public CurveTo(double cpx, double cpy, double x, double y) {
        super(ID, NAME);
        this.initialize(cpx, cpy, x, y);
    }

    private void initialize(double cpx, double cpy, double x, double y) {
        this.cpx = cpx;
        this.cpy = cpy;
        this.x = x;
        this.y = y;
    }

    @Override
    public Instruction createNew(Parameter[] params) throws Exception {
        if (params.length != 4) {
            throw new Exception("Param count does not match the Instruction");
        }
        return new CurveTo(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue());
    }

    @Override
    public String toMethod() {
        return super.toMethod() + this.getMethodParams();
    }

    @Override
    public String getMethodParams() {
        String methodParams = "(";
        methodParams = methodParams + this.cpx + ",";
        methodParams = methodParams + this.cpy + ",";
        methodParams = methodParams + this.x + ",";
        methodParams = methodParams + this.y;
        methodParams = methodParams + ")";
        return methodParams;
    }

    @Override
    public String toString() {
        return "CurveTo [cpx: " + this.cpx + ", cpy: " + this.cpy + ", x: " + this.x + ", y: " + this.y + "]";
    }

    public double getCpx() {
        return this.cpx;
    }

    public void setCpx(double cpx) {
        this.cpx = cpx;
    }

    public double getCpy() {
        return this.cpy;
    }

    public void setCpy(double cpy) {
        this.cpy = cpy;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

