/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;

public class BeginFill
extends Instruction {
    public static final String ID = "f";
    public static final String NAME = "beginFill";
    private String cssColor = null;

    public BeginFill() {
        super(ID, NAME);
        this.initialize("#FFFFFF");
    }

    public BeginFill(String cssColor) {
        super(ID, NAME);
        this.initialize(cssColor);
    }

    private void initialize(String cssColor) {
        this.cssColor = cssColor;
    }

    @Override
    public Instruction createNew(Parameter[] params) throws Exception {
        if (params != null) {
            if (params.length > 1) {
                throw new Exception("Param count does not match the Instruction");
            }
            if (params.length == 1) {
                return new BeginFill(params[0].getStringValue());
            }
        }
        return new BeginFill(null);
    }

    @Override
    public String toMethod() {
        return super.toMethod() + this.getMethodParams();
    }

    @Override
    public String getMethodParams() {
        if (this.cssColor == null || this.cssColor.equals("")) {
            return super.getMethodParams();
        }
        String methodParams = "(";
        methodParams = methodParams + "\"" + this.cssColor + "\"";
        methodParams = methodParams + ")";
        return methodParams;
    }

    @Override
    public String toString() {
        if (this.cssColor == null || this.cssColor.equals("")) {
            return "BeginFill []";
        }
        return "BeginFill [cssColor: \"" + this.cssColor + "\"]";
    }

    public String getCssColor() {
        return this.cssColor;
    }

    public void setCssColor(String cssColor) {
        this.cssColor = cssColor;
    }
}

