/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;

public class Parameter {
    public static final int UNKNOWN = 0;
    public static final int NUMBER = 1;
    public static final int NUMBER_ARRAY = 2;
    public static final int STRING = 3;
    public static final int STRING_ARRAY = 4;
    public static final int BOOLEAN = 5;
    private int type = 0;
    private Object value = null;

    public Parameter(Object value) {
        this.initialize(value);
    }

    private void initialize(Object value) {
        this.value = value;
        this.identifyValueType();
    }

    private void identifyValueType() {
        String stringValue;
        try {
            stringValue = (String)this.value;
        }
        catch (Exception e) {
            System.out.println("here!!: " + this.value);
            return;
        }
        if (stringValue.equals("true") || stringValue.equals("false")) {
            this.type = 5;
        } else if (NumberUtils.isNumber((String)stringValue)) {
            this.type = 1;
        } else {
            this.type = 3;
            if (this.checkStringForArray(stringValue)) {
                if (this.value instanceof Double[]) {
                    this.type = 2;
                } else if (this.value instanceof String[]) {
                    this.type = 4;
                }
            } else {
                this.value = stringValue.replaceAll("['|\"]", "");
            }
        }
    }

    private boolean checkStringForArray(String rawValue) {
        Pattern pattern = Pattern.compile("\\[.*\\]");
        Matcher matcher = pattern.matcher(rawValue);
        if (matcher.matches()) {
            this.value = this.createArray(rawValue);
            return true;
        }
        return false;
    }

    private Object[] createArray(String rawValue) {
        rawValue = rawValue.replaceAll("[\\[|\\]]", "");
        Pattern pattern = Pattern.compile("\"");
        Matcher matcher = pattern.matcher(rawValue);
        if (matcher.find()) {
            return this.createStringArray(rawValue);
        }
        return this.createNumberArray(rawValue);
    }

    private String[] createStringArray(String rawValue) {
        String[] valuesSplit = rawValue.split(",(?![^'|\"]*[^'|\"])");
        String[] stringValues = new String[valuesSplit.length];
        for (int i = 0; i < valuesSplit.length; ++i) {
            stringValues[i] = valuesSplit[i].replaceAll("['|\"]", "");
        }
        return stringValues;
    }

    private Double[] createNumberArray(String rawValue) {
        String[] valuesSplit = rawValue.split(",");
        Double[] doubleValues = new Double[valuesSplit.length];
        for (int i = 0; i < valuesSplit.length; ++i) {
            doubleValues[i] = Double.valueOf(valuesSplit[i]);
        }
        return doubleValues;
    }

    public int getType() {
        return this.type;
    }

    public Object getRawValue() {
        return this.value;
    }

    public Boolean getBooleanValue() {
        if (this.type == 5) {
            return Boolean.valueOf((String)this.value);
        }
        return null;
    }

    public String getStringValue() {
        if (this.type == 3) {
            return (String)this.value;
        }
        return null;
    }

    public String[] getStringArrayValue() {
        if (this.type == 4) {
            return (String[])this.value;
        }
        return null;
    }

    public Double getNumberValue() {
        if (this.type == 1) {
            return Double.valueOf((String)this.value);
        }
        return null;
    }

    public Double[] getNumberArrayValue() {
        if (this.type == 2) {
            return (Double[])this.value;
        }
        return null;
    }
}

