/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data;

import com.actionjava.mvn.plugins.assets.vo.Bounds;
import com.actionjava.mvn.plugins.assets.vo.Transform;

public abstract class Instance {
    private String id;
    private String name;
    private Bounds bounds;
    private Transform transform;

    public Instance(String id, String name) {
        this.initialize(id, name);
    }

    private void initialize(String id, String name) {
        this.id = id;
        this.name = name.substring(0, 1).toUpperCase() + name.substring(1);
        this.setTransform();
        this.setBounds();
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform() {
        this.setTransform(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void setTransform(Transform transform) {
        if (transform != null) {
            this.setTransform(transform.getX(), transform.getY(), transform.getScaleX(), transform.getScaleY(), transform.getRotation(), transform.getSkewX(), transform.getSkewY(), transform.getRegX(), transform.getRegY());
        }
    }

    public void setTransform(double x, double y) {
        this.setTransform(x, y, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void setTransform(double x, double y, double scaleX, double scaleY) {
        this.setTransform(x, y, scaleX, scaleY, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void setTransform(double x, double y, double scaleX, double scaleY, double rotation) {
        this.setTransform(x, y, scaleX, scaleY, rotation, 0.0, 0.0, 0.0, 0.0);
    }

    public void setTransform(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY) {
        this.setTransform(x, y, scaleX, scaleY, rotation, skewX, skewY, 0.0, 0.0);
    }

    public void setTransform(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY, double regX, double regY) {
        this.transform = new Transform(x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY);
    }

    public void setBounds() {
        this.setBounds(0.0, 0.0, 0.0, 0.0);
    }

    public void setBounds(Bounds bounds) {
        if (bounds != null) {
            this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
    }

    public void setBounds(double x, double y) {
        this.setBounds(x, y, 0.0, 0.0);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.bounds = new Bounds(x, y, width, height);
    }
}

