/*
 * Decompiled with CFR 0.152.
 */
package controller;

import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.web.mvc.components.FlowDataProvider;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import pipeline.developerexamples.clientsideelement.data.StarSignData;

@Controller
@RequestMapping(value={"/"})
public class ExampleController {
    private final FlowDataProvider flowDataProvider;
    private final Random rand = new Random();

    @Autowired
    public ExampleController(FlowDataProvider flowDataProvider) {
        this.flowDataProvider = flowDataProvider;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String get(ModelMap model, HttpServletRequest request) {
        String message = "";
        try (FlowData data = this.flowDataProvider.getFlowData(request);){
            message = "With a date of birth of " + data.getEvidence().get("cookie.date-of-birth") + ", your star sign is " + ((StarSignData)data.get(StarSignData.class)).getStarSign();
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        model.addAttribute("message", (Object)message);
        model.addAttribute("version", (Object)this.rand.nextInt());
        return "example";
    }
}

