/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.cache;

import fiftyone.mobile.detection.cache.ICacheLoader;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Cache<K, V> {
    private final Object writeLock = new Object();
    private final ICacheLoader<K, V> loader;
    private final ConcurrentHashMap<K, Node> hashMap;
    final DoublyLinkedList linkedList;
    private AtomicInteger cacheSize;
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong requests = new AtomicLong(0L);

    public Cache(int cacheSize) {
        this(cacheSize, null);
    }

    public Cache(int cacheSize, ICacheLoader<K, V> loader) {
        this.cacheSize = new AtomicInteger(cacheSize);
        this.loader = loader;
        this.hashMap = new ConcurrentHashMap(cacheSize);
        this.linkedList = new DoublyLinkedList();
    }

    public int getCacheSize() {
        return this.cacheSize.get();
    }

    public void setCacheSize(int size) {
        this.cacheSize.set(size);
    }

    public long getCacheMisses() {
        return this.misses.get();
    }

    public long getCacheRequests() {
        return this.requests.get();
    }

    public double getPercentageMisses() {
        return this.misses.doubleValue() / this.requests.doubleValue();
    }

    public V get(K key) throws IOException {
        return this.get(key, this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, ICacheLoader<K, V> loader) throws IOException {
        Object value;
        boolean added = false;
        this.requests.incrementAndGet();
        Node<KeyValuePair> node = this.hashMap.get(key);
        if (node == null) {
            this.misses.incrementAndGet();
            value = loader.fetch(key);
            Object object = this.writeLock;
            synchronized (object) {
                Node<KeyValuePair> newItem = new Node<KeyValuePair>(new KeyValuePair(key, value));
                node = this.hashMap.putIfAbsent(key, newItem);
                if (node == null) {
                    added = true;
                    node = newItem;
                    this.linkedList.addFirst(node);
                    this.removeLeastRecent();
                }
            }
        }
        if (!added) {
            value = this.writeLock;
            synchronized (value) {
                if (node.list != null) {
                    this.linkedList.remove(node);
                    this.linkedList.addFirst(node);
                }
            }
        }
        KeyValuePair kvp = (KeyValuePair)node.item;
        return kvp.value;
    }

    private void removeLeastRecent() {
        if (this.hashMap.size() > this.cacheSize.get()) {
            Node removedNode = this.linkedList.removeLast();
            KeyValuePair kvp = (KeyValuePair)removedNode.item;
            assert (this.hashMap.remove(kvp.key) != null);
            assert (this.hashMap.size() == this.cacheSize.get());
        }
    }

    public void resetCache() {
        this.hashMap.clear();
        this.linkedList.clear();
        this.misses.set(0L);
        this.requests.set(0L);
    }

    class DoublyLinkedList {
        Node first = null;
        Node last = null;

        DoublyLinkedList() {
        }

        void clear() {
            this.first = null;
            this.last = null;
        }

        void addFirst(Node newNode) {
            newNode.list = Cache.this.linkedList;
            if (this.first == null) {
                newNode.next = null;
                newNode.previous = null;
                this.first = newNode;
                this.last = newNode;
            } else {
                this.first.previous = newNode;
                newNode.next = this.first;
                newNode.previous = null;
                this.first = newNode;
            }
        }

        void remove(Node node) {
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            if (node == this.first) {
                this.first = this.first.next;
            }
            if (node == this.last) {
                this.last = this.last.previous;
            }
            node.list = null;
        }

        Node removeFirst() {
            Node result = this.first;
            if (this.first.next == null) {
                this.first = null;
                this.last = null;
            } else {
                this.first = this.first.next;
                this.first.previous = null;
            }
            result.list = null;
            return this.first;
        }

        Node removeLast() {
            Node result = this.last;
            if (this.first.next == null) {
                this.first = null;
                this.last = null;
            } else {
                this.last = this.last.previous;
                this.last.next = null;
            }
            result.list = null;
            return result;
        }
    }

    class Node<T> {
        final T item;
        Node next;
        Node previous;
        DoublyLinkedList list;

        public DoublyLinkedList getList() {
            return this.list;
        }

        public Node(T item) {
            this.item = item;
        }
    }

    class KeyValuePair {
        final K key;
        final V value;

        public KeyValuePair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

