/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.properties;

import fiftyone.mobile.detection.entities.Version;
import fiftyone.properties.DetectionConstants;
import java.util.HashMap;
import java.util.Map;

public class SupportedPatternFormatVersions {
    private final Map<DetectionConstants.FORMAT_VERSIONS, Version> patternVersions = new HashMap<DetectionConstants.FORMAT_VERSIONS, Version>();

    public SupportedPatternFormatVersions() {
        this.init();
    }

    private void init() {
        this.patternVersions.put(DetectionConstants.FORMAT_VERSIONS.PatternV31, new Version(3, 1, 0, 0));
        this.patternVersions.put(DetectionConstants.FORMAT_VERSIONS.PatternV32, new Version(3, 2, 0, 0));
    }

    public boolean contains(DetectionConstants.FORMAT_VERSIONS formatVersion) {
        return this.patternVersions.containsKey((Object)formatVersion);
    }

    public boolean contains(Version version) {
        for (Map.Entry<DetectionConstants.FORMAT_VERSIONS, Version> entry : this.patternVersions.entrySet()) {
            Version v = entry.getValue();
            if (!this.isSameVersion(v, version)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameVersion(Version one, Version two) {
        return one.build == two.build && one.major == two.major && one.minor == two.minor && one.revision == two.revision;
    }

    public Version getVersion(DetectionConstants.FORMAT_VERSIONS formatVersion) {
        if (this.contains(formatVersion)) {
            return this.patternVersions.get((Object)formatVersion);
        }
        return null;
    }

    public DetectionConstants.FORMAT_VERSIONS getEnum(Version version) {
        if (this.contains(version)) {
            for (Map.Entry<DetectionConstants.FORMAT_VERSIONS, Version> entry : this.patternVersions.entrySet()) {
                Version vT = entry.getValue();
                if (!this.isSameVersion(vT, version)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<DetectionConstants.FORMAT_VERSIONS, Version> entry : this.patternVersions.entrySet()) {
            sb.append(((Object)((Object)entry.getKey())).toString());
            sb.append(": ");
            sb.append(((Object)entry.getValue()).toString());
            sb.append(" ");
        }
        return sb.toString();
    }
}

