/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class TrieReader {
    private final ArrayList<MappedByteBuffer> _buffers;
    private final FileChannel _triFile;
    private final long _start;
    private long _position = 0L;
    private int _bufferIndex = 0;
    private long _globalPosition = 0L;

    public TrieReader(FileChannel reader) throws IOException {
        int bytesToRead;
        this._triFile = reader;
        double buffersNeededDouble = (double)reader.size() / 2.147483647E9;
        int buffersNeeded = (int)Math.ceil(buffersNeededDouble);
        this._buffers = new ArrayList(buffersNeeded);
        for (long readPosition = this._start = reader.position(); readPosition != reader.size(); readPosition += (long)bytesToRead) {
            long bytesLeft = reader.size() - readPosition;
            bytesToRead = bytesLeft > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)bytesLeft;
            MappedByteBuffer buffer = reader.map(FileChannel.MapMode.READ_ONLY, readPosition, bytesToRead);
            this._buffers.add(buffer);
        }
    }

    public long getPos() {
        return this._globalPosition;
    }

    public void setPos(long position) {
        this._globalPosition = position;
        for (int i = 0; i < this._buffers.size(); ++i) {
            if (position > (long)this._buffers.get(i).limit()) {
                position -= (long)this._buffers.get(i).limit();
                continue;
            }
            int p = (int)position;
            this._bufferIndex = i;
            this._buffers.get(i).position(p);
            break;
        }
        this._position = position;
    }

    public short readUByte() {
        short s = 0;
        byte[] value = this.getValue(DataType.Byte);
        s = (short)(s | value[0] & 0xFF);
        return s;
    }

    public short readUByte(long position) {
        this.setPos(position);
        return this.readUByte();
    }

    public int readUShort() {
        int i = 0;
        byte[] value = this.getValue(DataType.Unsigned_Short);
        i |= value[1] & 0xFF;
        i <<= 8;
        return i |= value[0] & 0xFF;
    }

    public int readUShort(long position) {
        this.setPos(position);
        return this.readUShort();
    }

    public long readUInt() throws IOException {
        long l = 0L;
        byte[] value = this.getValue(DataType.Unsigned_Int);
        l |= (long)(value[3] & 0xFF);
        l <<= 8;
        l |= (long)(value[2] & 0xFF);
        l <<= 8;
        l |= (long)(value[1] & 0xFF);
        l <<= 8;
        if ((l |= (long)(value[0] & 0xFF)) > 0xFFFFFFFEL) {
            throw new IOException("Trie reader could not read the unsigned integer: value is greater then unsigned integer max value.");
        }
        return l;
    }

    public int readInt() throws IOException {
        int r = 0;
        byte[] value = this.getValue(DataType.Unsigned_Int);
        for (int i = 0; i < value.length; ++i) {
            r = (int)((long)r + (((long)value[i] & 0xFFL) << 8 * i));
        }
        return r;
    }

    public long readLong() {
        long l = 0L;
        byte[] value = this.getValue(DataType.Long);
        for (int i = 0; i < value.length; ++i) {
            l += ((long)value[i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public long readLong(long position) throws IOException {
        this.setPos(position);
        return this.readLong();
    }

    private byte getNextByte() {
        int pos = (int)this._position;
        ++this._globalPosition;
        byte returnByte = this._buffers.get(this._bufferIndex).get(pos);
        if (this._buffers.get(this._bufferIndex).remaining() == 0) {
            ++this._bufferIndex;
            this._position = 0L;
        } else {
            ++this._position;
        }
        return returnByte;
    }

    public byte readByte() {
        return this.getNextByte();
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.getNextByte();
        }
        return bytes;
    }

    private byte[] getValue(DataType dataType) {
        int readSize;
        byte[] value;
        switch (dataType) {
            case Byte: {
                value = new byte[1];
                readSize = 1;
                break;
            }
            case Unsigned_Short: {
                value = new byte[2];
                readSize = 2;
                break;
            }
            case Unsigned_Int: {
                value = new byte[4];
                readSize = 4;
                break;
            }
            case Long: {
                value = new byte[8];
                readSize = 8;
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = 0; i < readSize; ++i) {
            value[i] = this.getNextByte();
        }
        return value;
    }

    public void close() throws IOException {
        for (ByteBuffer byteBuffer : this._buffers) {
            if (byteBuffer != null) {
                byteBuffer.clear();
            }
            Object var2_2 = null;
        }
        this._triFile.close();
    }

    private static enum DataType {
        Byte,
        Unsigned_Short,
        Unsigned_Int,
        Long;

    }
}

