/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.TrieProvider;
import fiftyone.mobile.detection.TrieProviderV3;
import fiftyone.mobile.detection.TrieProviderV32;
import fiftyone.mobile.detection.entities.stream.TriePool;
import fiftyone.mobile.detection.entities.stream.TrieSource;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.File;
import java.io.IOException;

public class TrieFactory {
    public static TrieProvider create(TriePool pool) throws IOException {
        TrieReader reader = pool.getReader();
        try {
            int version = reader.readUShort();
            switch (version) {
                case 3: {
                    TrieProviderV3 trieProviderV3 = new TrieProviderV3(new String(reader.readBytes((int)reader.readUInt())), TrieFactory.readStrings(reader), TrieFactory.readProperties(reader), TrieFactory.readDevices(reader), TrieFactory.readLookupList(reader), reader.readLong(), reader.getPos(), pool);
                    return trieProviderV3;
                }
                case 32: {
                    TrieProviderV32 trieProviderV32 = new TrieProviderV32(new String(reader.readBytes((int)reader.readUInt())), TrieFactory.readStrings(reader), TrieFactory.readHeaders(reader), TrieFactory.readProperties(reader), TrieFactory.readDevices(reader), TrieFactory.readLookupList(reader), reader.readLong(), reader.getPos(), pool);
                    return trieProviderV32;
                }
            }
            throw new IllegalArgumentException("The file you are trying to use is either of the wrong format or compressed or is not supported by this version of the API.");
        }
        finally {
            pool.release(reader);
        }
    }

    public static TrieProvider create(String file) throws IOException {
        return TrieFactory.create(file, false);
    }

    public static TrieProvider create(String file, boolean isTempFile) throws IOException {
        File f = new File(file);
        if (f.exists() && f.isFile()) {
            return TrieFactory.create(new TriePool(new TrieSource(file, isTempFile)));
        }
        throw new IOException("Selected filename is either a directory or does not exist: " + file);
    }

    private static short[] readLookupList(TrieReader reader) throws IOException {
        short[] lookupList = new short[reader.readInt()];
        for (int i = 0; i < lookupList.length; ++i) {
            lookupList[i] = reader.readUByte();
        }
        return lookupList;
    }

    private static byte[] readStrings(TrieReader reader) throws IOException {
        return reader.readBytes(reader.readInt());
    }

    private static byte[] readProperties(TrieReader reader) throws IOException {
        return reader.readBytes(reader.readInt());
    }

    private static byte[] readDevices(TrieReader reader) throws IOException {
        return reader.readBytes(reader.readInt());
    }

    private static byte[] readHeaders(TrieReader reader) throws IOException {
        return reader.readBytes((int)reader.readUInt());
    }
}

