/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.IntegerEntity;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.memory.PropertiesList;
import fiftyone.mobile.detection.entities.stream.FixedCacheList;
import fiftyone.mobile.detection.entities.stream.StreamFixedList;
import fiftyone.mobile.detection.entities.stream.StreamVariableList;
import fiftyone.mobile.detection.factories.AsciiStringFactory;
import fiftyone.mobile.detection.factories.CommonFactory;
import fiftyone.mobile.detection.factories.ComponentFactoryV31;
import fiftyone.mobile.detection.factories.ComponentFactoryV32;
import fiftyone.mobile.detection.factories.IntegerEntityFactory;
import fiftyone.mobile.detection.factories.MapFactory;
import fiftyone.mobile.detection.factories.ProfileOffsetFactory;
import fiftyone.mobile.detection.factories.PropertyFactory;
import fiftyone.mobile.detection.factories.RootNodeFactory;
import fiftyone.mobile.detection.factories.SignatureFactoryV31;
import fiftyone.mobile.detection.factories.SignatureFactoryV32;
import fiftyone.mobile.detection.factories.ValueFactory;
import fiftyone.mobile.detection.factories.stream.NodeStreamFactoryV31;
import fiftyone.mobile.detection.factories.stream.NodeStreamFactoryV32;
import fiftyone.mobile.detection.factories.stream.ProfileStreamFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public final class StreamFactory {
    public static fiftyone.mobile.detection.entities.stream.Dataset create(byte[] data) throws IOException {
        fiftyone.mobile.detection.entities.stream.Dataset dataSet = new fiftyone.mobile.detection.entities.stream.Dataset(data, Modes.MEMORY_MAPPED);
        StreamFactory.load(dataSet);
        return dataSet;
    }

    public static fiftyone.mobile.detection.entities.stream.Dataset create(String filePath, boolean isTempFile) throws IOException {
        return StreamFactory.create(filePath, new Date(new File(filePath).lastModified()), isTempFile);
    }

    public static fiftyone.mobile.detection.entities.stream.Dataset create(String filepath, Date lastModified, boolean isTempFile) throws IOException {
        fiftyone.mobile.detection.entities.stream.Dataset dataSet = new fiftyone.mobile.detection.entities.stream.Dataset(filepath, lastModified, Modes.FILE, isTempFile);
        StreamFactory.load(dataSet);
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(fiftyone.mobile.detection.entities.stream.Dataset dataSet) throws IOException {
        BinaryReader reader = null;
        try {
            MemoryFixedList<ProfileOffset> profileOffsets;
            MemoryFixedList<Node> rootNodes;
            PropertiesList properties;
            MemoryFixedList<Map> maps;
            reader = dataSet.pool.getReader();
            reader.setPos(0);
            CommonFactory.loadHeader(dataSet, reader);
            dataSet.strings = new StreamVariableList<AsciiString>(dataSet, reader, new AsciiStringFactory(), 8000);
            MemoryFixedList<Component> components = null;
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV31());
                    break;
                }
                case PatternV32: {
                    components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV32());
                }
            }
            dataSet.components = components;
            dataSet.maps = maps = new MemoryFixedList<Map>(dataSet, reader, new MapFactory());
            dataSet.properties = properties = new PropertiesList((Dataset)dataSet, reader, new PropertyFactory());
            dataSet.values = new FixedCacheList<Value>(dataSet, reader, new ValueFactory(), 3000);
            dataSet.profiles = new StreamVariableList<Profile>(dataSet, reader, new ProfileStreamFactory(), 600);
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    dataSet.signatures = new FixedCacheList<Signature>(dataSet, reader, new SignatureFactoryV31(dataSet), 16000);
                    break;
                }
                case PatternV32: {
                    dataSet.signatures = new FixedCacheList<Signature>(dataSet, reader, new SignatureFactoryV32(dataSet), 16000);
                    dataSet.signatureNodeOffsets = new StreamFixedList<IntegerEntity>(dataSet, reader, new IntegerEntityFactory());
                    dataSet.nodeRankedSignatureIndexes = new StreamFixedList<IntegerEntity>(dataSet, reader, new IntegerEntityFactory());
                }
            }
            dataSet.rankedSignatureIndexes = new FixedCacheList<IntegerEntity>(dataSet, reader, new IntegerEntityFactory(), 16000);
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    dataSet.nodes = new StreamVariableList<Node>(dataSet, reader, new NodeStreamFactoryV31(), 30000);
                    break;
                }
                case PatternV32: {
                    dataSet.nodes = new StreamVariableList<Node>(dataSet, reader, new NodeStreamFactoryV32(), 30000);
                }
            }
            dataSet.rootNodes = rootNodes = new MemoryFixedList<Node>(dataSet, reader, new RootNodeFactory());
            dataSet.profileOffsets = profileOffsets = new MemoryFixedList<ProfileOffset>(dataSet, reader, new ProfileOffsetFactory());
            reader.setPos(components.header.getStartPosition());
            components.read(reader);
            reader.setPos(maps.header.getStartPosition());
            maps.read(reader);
            reader.setPos(properties.header.getStartPosition());
            properties.read(reader);
            reader.setPos(rootNodes.header.getStartPosition());
            rootNodes.read(reader);
            reader.setPos(profileOffsets.header.getStartPosition());
            profileOffsets.read(reader);
        }
        finally {
            if (reader != null) {
                dataSet.pool.release(reader);
            }
        }
    }
}

