/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.stream.ICacheList;
import fiftyone.mobile.detection.entities.stream.Pool;
import fiftyone.mobile.detection.readers.SourceBase;
import fiftyone.mobile.detection.readers.SourceFile;
import fiftyone.mobile.detection.readers.SourceMemory;
import java.io.IOException;
import java.util.Date;

public class Dataset
extends fiftyone.mobile.detection.Dataset {
    public final Pool pool;
    private final SourceBase source;

    public Dataset(String fileName, Date lastModified, Modes mode, boolean isTempFile) throws IOException {
        super(lastModified, mode);
        this.source = new SourceFile(fileName, false);
        this.pool = new Pool(this.source);
    }

    public Dataset(byte[] data, Modes mode) throws IOException {
        super(new Date(Long.MIN_VALUE), mode);
        this.source = new SourceMemory(data);
        this.pool = new Pool(this.source);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        super.close();
    }

    @Override
    public void resetCache() {
        super.resetCache();
        ((ICacheList)((Object)this.signatures)).resetCache();
        ((ICacheList)((Object)this.nodes)).resetCache();
        ((ICacheList)((Object)this.strings)).resetCache();
        ((ICacheList)((Object)this.profiles)).resetCache();
        ((ICacheList)((Object)this.values)).resetCache();
        ((ICacheList)((Object)this.rankedSignatureIndexes)).resetCache();
    }

    public int getReadersCreated() {
        return this.pool.getReadersCreated();
    }

    public int getReadersQueued() {
        return this.pool.getReadersQueued();
    }
}

