/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.search.SearchArrays;
import java.io.IOException;

public class Values {
    private static final SearchValuesByName valuesNameSearch = new SearchValuesByName();
    private final Property property;
    private final Value[] values;

    Values(Property property, Value[] values) {
        this.values = values;
        this.property = property;
    }

    public boolean toBool() throws IOException {
        if (this.property.isList) {
            throw new UnsupportedOperationException("Can't convert list to a boolean.");
        }
        if (this.values.length > 0) {
            return this.get(0).toBool();
        }
        return false;
    }

    public double toDouble() throws IOException {
        if (this.property.isList) {
            throw new UnsupportedOperationException("Can't convert list to double.");
        }
        if (this.values.length > 0) {
            return this.get(0).toDouble();
        }
        return 0.0;
    }

    public String[] toStringArray() throws IOException {
        String[] array = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            array[i] = this.get(i).getName();
        }
        return array;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            result.append(this.get(i));
            if (i == this.values.length - 1) continue;
            result.append("|");
        }
        return result.toString();
    }

    public boolean getIsDefault() throws IOException {
        for (Value value : this.values) {
            if (!value.getIsDefault()) continue;
            return true;
        }
        return false;
    }

    public Value[] getAll() {
        return this.values;
    }

    public Value get(String valueName) throws IOException {
        int index = valuesNameSearch.binarySearch(this.values, valueName).getIndex();
        return index >= 0 ? this.get(index) : null;
    }

    public Value get(int index) {
        if (index > this.values.length) {
            return null;
        }
        return this.values[index];
    }

    public boolean contains(Value item) {
        for (Value v : this.values) {
            if (!v.equals(item)) continue;
            return true;
        }
        return false;
    }

    public void copyTo(Value[] array, int arrayIndex) {
        int current = arrayIndex;
        int i = 0;
        while (current < this.values.length) {
            array[i] = this.values[current];
            ++current;
            ++i;
        }
    }

    public int count() {
        return this.values.length;
    }

    private static class SearchValuesByName
    extends SearchArrays<Value, String> {
        private SearchValuesByName() {
        }

        @Override
        public int compareTo(Value item, String key) {
            return item.compareTo(key);
        }
    }
}

