/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.NodeIndex;
import fiftyone.mobile.detection.entities.NodeNumericIndex;
import fiftyone.mobile.detection.entities.Range;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.mobile.detection.search.SearchArrays;
import java.io.IOException;

public abstract class Node
extends BaseEntity
implements Comparable<Node> {
    public static final int NODE_INDEX_LENGTH = 9;
    public static final int NODE_NUMERIC_INDEX_LENGTH = 6;
    private static final SearchNodeNumericIndex numericChildrenSearch = new SearchNodeNumericIndex();
    private static final Range[] ranges = new Range[]{new Range(0, 10), new Range(10, 100), new Range(100, 1000), new Range(1000, 10000), new Range(10000, Short.MAX_VALUE)};
    private volatile byte[] characters;
    protected final long nodeStartStreamPosition;
    protected final short numericChildrenCount;
    protected final short childrenCount;
    protected NodeIndex[] children;
    final int parentOffset;
    private final int characterStringOffset;
    public final short nextCharacterPosition;
    public final short position;
    protected int rankedSignatureCount;
    private volatile Node parent = null;
    private volatile Node root;

    public Node(Dataset dataSet, int offset, BinaryReader reader) {
        super(dataSet, offset);
        this.nodeStartStreamPosition = reader.getPos();
        this.position = reader.readInt16();
        this.nextCharacterPosition = reader.readInt16();
        this.parentOffset = reader.readInt32();
        this.characterStringOffset = reader.readInt32();
        this.childrenCount = reader.readInt16();
        this.numericChildrenCount = reader.readInt16();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getRoot() throws IOException {
        Node localRoot = this.root;
        if (localRoot == null) {
            Node node = this;
            synchronized (node) {
                localRoot = this.root;
                if (localRoot == null) {
                    localRoot = this.getParent() == null ? this : this.getParent().getRoot();
                    this.root = localRoot;
                }
            }
        }
        return localRoot;
    }

    Node getParent() throws IOException {
        Node localParent = this.parent;
        if (this.parentOffset >= 0 && localParent == null && (localParent = this.parent) == null) {
            this.parent = localParent = this.getDataSet().getNodes().get(this.parentOffset);
        }
        return localParent;
    }

    boolean isComplete() {
        return this.characterStringOffset >= 0;
    }

    @Override
    public int compareTo(Node other) {
        return super.compareTo(other);
    }

    public int getLength() throws IOException {
        return this.getRoot().position - this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCharacters() throws IOException {
        byte[] localCharacters = this.characters;
        if (localCharacters == null && this.characterStringOffset >= 0) {
            Node node = this;
            synchronized (node) {
                localCharacters = this.characters;
                if (localCharacters == null) {
                    localCharacters = super.getDataSet().strings.get((int)this.characterStringOffset).value;
                    this.characters = super.getDataSet().strings.get((int)this.characterStringOffset).value;
                }
            }
        }
        return localCharacters;
    }

    public NodeNumericIndex[] readNodeNumericIndexes(Dataset dataSet, BinaryReader reader, short count) {
        NodeNumericIndex[] array = new NodeNumericIndex[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new NodeNumericIndex(dataSet, reader.readInt16(), reader.readInt32());
        }
        return array;
    }

    public abstract int[] getRankedSignatureIndexes() throws IOException;

    public int getChildrenLength() {
        return this.children.length;
    }

    public int getNumericChildrenLength() {
        return this.numericChildrenCount;
    }

    public abstract NodeNumericIndex[] getNumericChildren() throws IOException;

    public void init() throws IOException {
        if (this.isComplete() && this.characters == null) {
            this.characters = this.getCharacters();
        }
        if (this.parent == null && this.parentOffset >= 0) {
            this.parent = this.dataSet.nodes.get(this.parentOffset);
        }
        if (this.root == null) {
            this.root = this.parent == null ? this : this.parent.root;
        }
        for (NodeIndex child : this.children) {
            child.init();
        }
    }

    public Node getCompleteNumericNode(MatchState state) throws IOException {
        NodeNumericIndexIterator iterator;
        int target;
        Node node = null;
        Node nextNode = this.getNextNode(state);
        if (nextNode != null) {
            node = nextNode.getCompleteNumericNode(state);
        }
        if (node == null && this.numericChildrenCount > 0 && (target = this.getCurrentPositionAsNumeric(state)) >= 0 && (iterator = this.getNumericNodeIterator(target)) != null) {
            while (iterator.hasNext()) {
                NodeNumericIndex current = iterator.next();
                node = current.getNode().getCompleteNumericNode(state);
                if (node == null) continue;
                int difference = Math.abs(target - current.getValue());
                state.incrLowestScore(difference);
                break;
            }
        }
        if (node == null && this.isComplete()) {
            node = this;
        }
        return node;
    }

    private NodeNumericIndexIterator getNumericNodeIterator(int target) throws IOException {
        if (target >= 0 && target <= Short.MAX_VALUE) {
            Range range = this.getRange(target);
            int startIndex = numericChildrenSearch.binarySearch(this.getNumericChildren(), target).getIndex();
            if (startIndex < 0) {
                startIndex = ~startIndex - 1;
            }
            return new NodeNumericIndexIterator(range, this.getNumericChildren(), target, startIndex);
        }
        return null;
    }

    private Range getRange(int target) {
        for (Range range : ranges) {
            if (!range.inRange(target)) continue;
            return range;
        }
        return ranges[ranges.length - 1];
    }

    private int getCurrentPositionAsNumeric(MatchState state) {
        int i;
        for (i = this.position; i >= 0 && state.getTargetUserAgentArray()[i] >= 48 && state.getTargetUserAgentArray()[i] <= 57; --i) {
        }
        if (i < this.position) {
            return Node.getNumber(state.getTargetUserAgentArray(), i + 1, this.position - i);
        }
        return -1;
    }

    public Node getCompleteNode(MatchState state) throws IOException {
        Node node = null;
        Node nextNode = this.getNextNode(state);
        if (nextNode != null) {
            node = nextNode.getCompleteNode(state);
        }
        if (node == null && this.isComplete()) {
            node = this;
        }
        return node;
    }

    private Node getNextNode(MatchState state) throws IOException {
        int upper = this.children.length - 1;
        if (upper >= 0) {
            int lower = 0;
            int middle = lower + (upper - lower) / 2;
            int length = this.children[middle].getCharacters().length;
            int startIndex = this.position - length + 1;
            while (lower <= upper) {
                middle = lower + (upper - lower) / 2;
                if (this.children[middle].isString) {
                    state.incrStringsRead();
                }
                state.incrNodesEvaluated();
                int comparisonResult = this.children[middle].compareTo(state.getTargetUserAgentArray(), startIndex);
                if (comparisonResult == 0) {
                    return this.children[middle].getNode();
                }
                if (comparisonResult > 0) {
                    upper = middle - 1;
                    continue;
                }
                lower = middle + 1;
            }
        }
        return null;
    }

    private boolean getIsOverlap(Node node) throws IOException {
        Node lower = node.position < this.position ? node : this;
        Node higher = lower == this ? node : this;
        return lower.position == higher.position || lower.getRoot().position > higher.position;
    }

    public boolean getIsOverlap(MatchState state) throws IOException {
        for (Node node : state.getNodesList()) {
            if (!this.getIsOverlap(node)) continue;
            return true;
        }
        return false;
    }

    public void addCharacters(byte[] values) throws IOException {
        if (this.getParent() != null) {
            byte[] nodeCharacters = this.characters == null ? this.dataSet.strings.get((int)this.characterStringOffset).value : this.getCharacters();
            for (int i = 0; i < this.getLength(); ++i) {
                values[this.position + i + 1] = nodeCharacters[i];
            }
        }
    }

    public String toString() {
        try {
            byte[] values = new byte[this.getDataSet().maxUserAgentLength];
            this.addCharacters(values);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != 0) continue;
                values[i] = 32;
            }
            return new String(values);
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    static class NodeNumericIndexIterator {
        private final NodeNumericIndex[] array;
        private final int target;
        private final Range range;
        private int lowIndex;
        private int highIndex;
        private boolean lowInRange;
        private boolean highInRange;

        NodeNumericIndexIterator(Range range, NodeNumericIndex[] array, int target, int startIndex) {
            this.range = range;
            this.array = array;
            this.target = target;
            this.lowIndex = startIndex;
            this.highIndex = startIndex + 1;
            this.lowInRange = this.lowIndex >= 0 && this.lowIndex < array.length && this.range.inRange(array[this.lowIndex].getValue());
            this.highInRange = this.highIndex < array.length && this.highIndex >= 0 && this.range.inRange(array[this.highIndex].getValue());
        }

        boolean hasNext() {
            return this.lowInRange || this.highInRange;
        }

        NodeNumericIndex next() {
            int index;
            if (this.lowInRange && this.highInRange) {
                int highDifference;
                int lowDifference = Math.abs(this.array[this.lowIndex].getValue() - this.target);
                if (lowDifference <= (highDifference = Math.abs(this.array[this.highIndex].getValue() - this.target))) {
                    index = this.lowIndex--;
                    this.lowInRange = this.lowIndex >= 0 && this.range.inRange(this.array[this.lowIndex].getValue());
                } else {
                    index = this.highIndex++;
                    this.highInRange = this.highIndex < this.array.length && this.range.inRange(this.array[this.highIndex].getValue());
                }
            } else if (this.lowInRange) {
                index = this.lowIndex--;
                this.lowInRange = this.lowIndex >= 0 && this.range.inRange(this.array[this.lowIndex].getValue());
            } else {
                index = this.highIndex++;
                boolean bl = this.highInRange = this.highIndex < this.array.length && this.range.inRange(this.array[this.highIndex].getValue());
            }
            if (index >= 0) {
                return this.array[index];
            }
            return null;
        }
    }

    private static class SearchNodeNumericIndex
    extends SearchArrays<NodeNumericIndex, Integer> {
        private SearchNodeNumericIndex() {
        }

        @Override
        public int compareTo(NodeNumericIndex item, Integer key) {
            return item.compareTo(key);
        }
    }
}

