/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.MatchState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class MostFrequentFilter
extends ArrayList<Integer> {
    MostFrequentFilter(int[][] lists, int maxResults) {
        OrderedList[] localLists = new OrderedList[lists.length];
        for (int i = 0; i < lists.length; ++i) {
            localLists[i] = new OrderedList(lists[i]);
        }
        this.Init(localLists, maxResults);
    }

    MostFrequentFilter(MatchState state) throws IOException {
        OrderedList[] localLists = new OrderedList[state.getNodes().length];
        for (int i = 0; i < state.getNodes().length; ++i) {
            localLists[i] = new OrderedList(state.getNodes()[i].getRankedSignatureIndexes());
        }
        this.Init(localLists, state.getDataSet().maxSignatures);
    }

    private void Init(OrderedList[] lists, int maxResults) {
        int topCount = 0;
        if (lists.length == 1) {
            if (lists[0].items.length < maxResults) {
                maxResults = lists[0].items.length;
            }
            for (int i = 0; i < maxResults; ++i) {
                this.add(lists[0].items[i]);
            }
        } else if (lists.length > 1) {
            Arrays.sort(lists, new Comparator<OrderedList>(){

                @Override
                public int compare(OrderedList o1, OrderedList o2) {
                    return o1.items.length - o2.items.length;
                }
            });
            for (int listIndex = 0; listIndex < lists.length && lists.length - listIndex >= topCount; ++listIndex) {
                for (OrderedList ol : lists) {
                    ol.reset();
                }
                while (lists[listIndex].moveNext()) {
                    if (this.getHasProcessed(lists, listIndex)) continue;
                    int count = this.getCount(lists, listIndex, topCount);
                    if (count > topCount) {
                        topCount = count;
                        this.clear();
                    }
                    if (count != topCount) continue;
                    this.add(lists[listIndex].current());
                }
            }
        }
        Collections.sort(this);
        if (this.size() > maxResults) {
            this.removeRange(maxResults, this.size());
        }
    }

    private boolean getHasProcessed(OrderedList[] lists, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (!lists[i].contains(lists[index].current())) continue;
            return true;
        }
        return false;
    }

    private int getCount(OrderedList[] lists, int index, int topCount) {
        int count = 1;
        for (int i = index + 1; i < lists.length && lists.length - index + count > topCount; ++i) {
            if (!lists[i].contains(lists[index].current())) continue;
            ++count;
        }
        return count;
    }

    private class OrderedList {
        private final int[] items;
        private int nextStartIndex;
        private int currentIndex;

        OrderedList(int[] items) {
            this.items = items;
            this.nextStartIndex = 0;
            this.currentIndex = -1;
        }

        boolean contains(int value) {
            int itemIndex = Arrays.binarySearch(this.items, this.nextStartIndex, this.items.length, value);
            this.nextStartIndex = itemIndex < 0 ? ~itemIndex : itemIndex + 1;
            return itemIndex >= 0;
        }

        int current() {
            return this.items[this.currentIndex];
        }

        boolean moveNext() {
            ++this.currentIndex;
            return this.currentIndex < this.items.length;
        }

        void reset() {
            this.currentIndex = -1;
            this.nextStartIndex = 0;
        }
    }
}

