/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.ISimpleList;
import fiftyone.mobile.detection.IndirectDataset;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IntegerList
implements ISimpleList {
    private final Header header;
    protected final IndirectDataset dataSet;

    public IntegerList(IndirectDataset dataSet, BinaryReader reader) {
        this.header = new Header(reader);
        this.dataSet = dataSet;
    }

    @Override
    public int get(int index) {
        int result;
        BinaryReader reader = null;
        try {
            reader = this.dataSet.pool.getReader();
            reader.setPos(this.header.getStartPosition() + 4 * index);
            result = reader.readInt32();
        }
        catch (IOException ex) {
            throw new WrappedIOException("Failed to access data file to retrieve a binary reader");
        }
        finally {
            if (reader != null) {
                this.dataSet.pool.release(reader);
            }
        }
        return result;
    }

    @Override
    public List<Integer> getRange(int index, int count) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        BinaryReader reader = null;
        try {
            reader = this.dataSet.pool.getReader();
            reader.setPos(this.header.getStartPosition() + 4 * index);
            for (int i = 0; i < count; ++i) {
                result.add(reader.readInt32());
            }
        }
        catch (IOException ex) {
            throw new WrappedIOException("Failed to access data file to retrieve a binary reader");
        }
        finally {
            if (reader != null) {
                this.dataSet.pool.release(reader);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.header.getCount();
    }
}

