/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IReadonlyList;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MemoryBaseList<T extends BaseEntity>
implements IReadonlyList<T>,
Closeable {
    protected final List<T> array;
    protected final Dataset dataSet;
    protected final BaseEntityFactory<T> entityFactory;
    public final Header header;

    MemoryBaseList(Dataset dataSet, BinaryReader reader, BaseEntityFactory<T> entityFactory) {
        this.header = new Header(reader);
        int count = this.header.getCount();
        this.array = new ArrayList<T>(count);
        this.dataSet = dataSet;
        this.entityFactory = entityFactory;
    }

    @Override
    public void close() {
        this.array.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.array.iterator();
    }

    @Override
    public int size() {
        return this.array.size();
    }

    public abstract void read(BinaryReader var1) throws IOException;
}

