/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.IndirectDataset;
import fiftyone.mobile.detection.entities.stream.Node;
import fiftyone.mobile.detection.factories.NodeFactoryShared;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NodeV32
extends Node {
    private volatile List<Integer> rankedSignatureIndexes;

    public NodeV32(IndirectDataset dataSet, int offset, BinaryReader reader) throws IOException {
        super(dataSet, offset, reader);
        this.rankedSignatureCount = reader.readUInt16();
        this.children = NodeFactoryShared.readNodeIndexesV32(dataSet, reader, (int)((long)(offset + reader.getPos()) - this.nodeStartStreamPosition), this.childrenCount);
        this.numericChildrenPosition = reader.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getRankedSignatureIndexes() throws IOException {
        List<Integer> localRankedSignatureIndexes = this.rankedSignatureIndexes;
        if (localRankedSignatureIndexes == null) {
            NodeV32 nodeV32 = this;
            synchronized (nodeV32) {
                localRankedSignatureIndexes = this.rankedSignatureIndexes;
                if (localRankedSignatureIndexes == null) {
                    this.rankedSignatureIndexes = localRankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
                }
            }
        }
        return localRankedSignatureIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRankedSignatureIndexValue() throws IOException {
        BinaryReader reader = this.pool.getReader();
        try {
            reader.setPos(this.numericChildrenPosition + 6 * this.getNumericChildrenLength());
            int n = reader.readInt32();
            return n;
        }
        finally {
            this.pool.release(reader);
        }
    }

    private List<Integer> getRankedSignatureIndexesAsArray() throws IOException {
        List<Integer> rsi = null;
        if (this.rankedSignatureCount == 0) {
            rsi = new ArrayList<Integer>(0);
        } else {
            int rankedSignatureValue = this.getRankedSignatureIndexValue();
            if (this.rankedSignatureCount == 1) {
                rsi = new ArrayList();
                rsi.add(rankedSignatureValue);
            } else {
                rsi = this.dataSet.getNodeRankedSignatureIndexes().getRange(rankedSignatureValue, this.rankedSignatureCount);
            }
        }
        return rsi;
    }
}

