/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.TrieProvider;
import fiftyone.mobile.detection.entities.stream.TriePool;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;

public class TrieProviderV32
extends TrieProvider {
    private static final int PROPERTY_LENGTH = 12;

    public TrieProviderV32(String copyright, byte[] strings, byte[] httpHeaders, byte[] properties, byte[] devices, short[] lookupList, long nodesLength, long nodesOffset, TriePool pool) throws FileNotFoundException {
        super(copyright, strings, properties, devices, lookupList, nodesLength, nodesOffset, pool);
        int limit = this._properties.array().length / 12;
        for (int i = 0; i < limit; ++i) {
            String value = this.getStringValue(this._properties.getInt());
            int headerCount = this._properties.getInt();
            int headerFirstIndex = this._properties.getInt();
            this._propertyIndex.put(value, i);
            this._propertyNames.add(value);
            this.propertyHttpHeaders.add(this.getHeaders(httpHeaders, headerCount, headerFirstIndex));
        }
    }

    private String[] getHeaders(byte[] httpHeaders, int headerCount, int headerFirstIndex) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < headerCount; ++i) {
            int from = (headerFirstIndex + i) * 4;
            int to = from + 4;
            byte[] value = Arrays.copyOfRange(httpHeaders, from, to);
            ByteBuffer buffer = ByteBuffer.wrap(value);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            short offset = buffer.getShort();
            headers.add(this.getStringValue(offset));
        }
        return headers.toArray(new String[headers.size()]);
    }
}

