/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.stream.TriePool;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class TrieProvider
implements Closeable {
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_UINT = 4;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_USHORT = 2;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_UBYTE = 1;
    private static final int SIZE_OF_BYTE = 1;
    public String copyright;
    private final ByteBuffer _Strings;
    protected ByteBuffer _properties;
    private final ByteBuffer _devices;
    private final short[] _lookupList;
    private final TriePool pool;
    private final long _nodesOffset;
    protected final Map<String, Integer> _propertyIndex = new HashMap<String, Integer>();
    protected final List<String> _propertyNames = new ArrayList<String>();
    protected final List<String[]> propertyHttpHeaders = new ArrayList<String[]>();
    private volatile List<String> httpHeaders;

    public List<String> propertyNames() {
        return this._propertyNames;
    }

    public TrieProvider(String copyright, byte[] strings, byte[] properties, byte[] devices, short[] lookupList, long nodesLength, long nodesOffset, TriePool pool) throws FileNotFoundException {
        this.copyright = copyright;
        this._Strings = ByteBuffer.wrap(strings);
        this._properties = ByteBuffer.wrap(properties);
        this._devices = ByteBuffer.wrap(devices);
        this._lookupList = lookupList;
        this._nodesOffset = nodesOffset;
        this.pool = pool;
        this._Strings.order(ByteOrder.LITTLE_ENDIAN);
        this._properties.order(ByteOrder.LITTLE_ENDIAN);
        this._devices.order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHttpHeaders() {
        List<String> localHttpHeaders = this.httpHeaders;
        if (localHttpHeaders == null) {
            TrieProvider trieProvider = this;
            synchronized (trieProvider) {
                localHttpHeaders = this.httpHeaders;
                if (localHttpHeaders == null) {
                    this.httpHeaders = localHttpHeaders = new ArrayList<String>();
                    for (String[] sa : this.propertyHttpHeaders) {
                        for (String s : sa) {
                            if (this.httpHeaders.contains(s)) continue;
                            this.httpHeaders.add(s);
                        }
                    }
                }
            }
        }
        return localHttpHeaders;
    }

    public String getUserAgent(String userAgent) throws Exception {
        StringBuilder matchedUserAgent = new StringBuilder();
        TrieReader reader = this.pool.getReader();
        reader.setPos(this._nodesOffset);
        this.getDeviceIndex(reader, TrieProvider.getUserAgentByteArray(userAgent), 0, 0, matchedUserAgent);
        this.pool.release(reader);
        return matchedUserAgent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceIndex(String userAgent) throws Exception {
        int index;
        TrieReader reader = this.pool.getReader();
        try {
            reader.setPos(this._nodesOffset);
            index = this.getDeviceIndex(reader, TrieProvider.getUserAgentByteArray(userAgent), 0, 0);
        }
        finally {
            this.pool.release(reader);
        }
        return index;
    }

    public String getDeviceId(int deviceIndex) {
        return this.getPropertyValue(deviceIndex, "Id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getDeviceIndexes(Map<String, String> headers) throws IOException, Exception {
        TreeMap<String, Integer> indexes = new TreeMap<String, Integer>();
        if (headers != null) {
            TrieReader reader = null;
            try {
                reader = this.pool.getReader();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String header = entry.getKey().toString();
                    if (!this.getHttpHeaders().contains(header)) continue;
                    indexes.put(header, this.getDeviceIndex(headers.get(header)));
                }
            }
            finally {
                if (reader != null) {
                    this.pool.release(reader);
                }
            }
        } else {
            indexes.put("User-Agent", this.getDeviceIndex(null));
        }
        return indexes;
    }

    public String getPropertyValue(int deviceIndex, String property) {
        return this.getPropertyValue(deviceIndex, (int)this._propertyIndex.get(property));
    }

    public String getPropertyValue(Map<String, Integer> deviceIndexes, String property) {
        if (deviceIndexes == null || deviceIndexes.isEmpty()) {
            return this.getDefaultPropertyValue(property);
        }
        return this.getPropertyValue(deviceIndexes, (int)this._propertyIndex.get(property));
    }

    public String getDefaultPropertyValue(String propertyName) {
        return this.getPropertyValue(0, propertyName);
    }

    public String getPropertyValue(Map<String, Integer> deviceIndexes, int propertyIndex) {
        for (String header : this.propertyHttpHeaders.get(propertyIndex)) {
            Integer deviceIndex = deviceIndexes.get(header);
            if (deviceIndex == null) continue;
            return this.getPropertyValue((int)deviceIndex, propertyIndex);
        }
        return null;
    }

    public String getPropertyValue(int deviceIndex, int propertyIndex) {
        int devicePosition = deviceIndex * this._propertyNames.size() * 4;
        int offset = devicePosition + propertyIndex * 4;
        return this.getStringValue(this._devices.getInt(offset));
    }

    public String getPropertyValueWithMultiHeaders(Map<String, String> headers, String propertyName) throws Exception {
        return this.getPropertyValue(this.getDeviceIndexes(headers), propertyName);
    }

    public String getPropertyValue(String userAgent, String propertyname) throws Exception {
        return this.getPropertyValue(this.getDeviceIndex(userAgent), propertyname);
    }

    @Override
    public void close() {
        this.pool.close();
    }

    protected String getStringValue(int offset) {
        int index = 0;
        StringBuilder builder = new StringBuilder();
        byte current = this._Strings.get(offset);
        while (current != 0) {
            builder.append((char)current);
            current = this._Strings.get(offset + ++index);
        }
        return builder.toString();
    }

    private static byte[] getUserAgentByteArray(String userAgent) {
        byte[] result = new byte[userAgent != null ? userAgent.length() + 1 : 0];
        if (result.length > 0) {
            for (int i = 0; i < userAgent.length(); ++i) {
                result[i] = userAgent.charAt(i) <= '\u007f' ? (int)userAgent.charAt(i) : 32;
            }
            result[result.length - 1] = 0;
        }
        return result;
    }

    private short getChild(int lookupOffset, byte value) throws ArrayIndexOutOfBoundsException {
        try {
            short lowest = this._lookupList[lookupOffset];
            short highest = this._lookupList[lookupOffset + 1];
            if (value < lowest || value > highest) {
                return 127;
            }
            int index = lookupOffset + value - lowest + 2;
            return this._lookupList[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
    }

    public static int sizeOfOffsets(OffsetType offsetType) {
        switch (offsetType) {
            case Bits16: {
                return 2;
            }
            case Bits32: {
                return 4;
            }
        }
        return 8;
    }

    private void setNextNodePosition(TrieReader reader, short childIndex, short numberOfChildren, OffsetType offsetType) throws IOException {
        if (childIndex == 0) {
            long offset = reader.getPos() + (long)((numberOfChildren - 1) * TrieProvider.sizeOfOffsets(offsetType));
            reader.setPos(offset);
        } else {
            reader.setPos(reader.getPos() + (long)((childIndex - 1) * TrieProvider.sizeOfOffsets(offsetType)));
            long pos = reader.getPos();
            switch (offsetType) {
                case Bits16: {
                    pos += (long)reader.readUShort();
                    break;
                }
                case Bits32: {
                    pos += reader.readUInt();
                    break;
                }
                default: {
                    pos += reader.readLong();
                }
            }
            reader.setPos(pos);
        }
    }

    private int getDeviceIndex(TrieReader reader, byte[] userAgent, int index, int parentDeviceIndex) throws Exception {
        int lookupListOffset = reader.readInt();
        if (index == userAgent.length) {
            return parentDeviceIndex;
        }
        short childIndex = this.getChild(Math.abs(lookupListOffset), userAgent[index]);
        int deviceIndex = lookupListOffset >= 0 ? reader.readInt() : parentDeviceIndex;
        if (childIndex == 127) {
            return deviceIndex;
        }
        byte numberOfChildren = reader.readByte();
        if (childIndex >= numberOfChildren) {
            return deviceIndex;
        }
        if (numberOfChildren == 1) {
            return this.getDeviceIndex(reader, userAgent, index + 1, deviceIndex);
        }
        OffsetType offsetType = OffsetType.fromByte(reader.readByte());
        this.setNextNodePosition(reader, childIndex, numberOfChildren, offsetType);
        return this.getDeviceIndex(reader, userAgent, index + 1, deviceIndex);
    }

    private int getDeviceIndex(TrieReader reader, byte[] userAgent, int index, int parentDeviceIndex, StringBuilder matchedUserAgent) throws Exception {
        matchedUserAgent.append((char)userAgent[index]);
        int lookupListOffset = reader.readInt();
        short childIndex = this.getChild(Math.abs(lookupListOffset), userAgent[index]);
        int deviceIndex = lookupListOffset >= 0 ? reader.readInt() : parentDeviceIndex;
        if (childIndex == 127) {
            return deviceIndex;
        }
        byte numberOfChildren = reader.readByte();
        if (childIndex >= numberOfChildren) {
            return deviceIndex;
        }
        if (numberOfChildren == 1) {
            return this.getDeviceIndex(reader, userAgent, index + 1, deviceIndex, matchedUserAgent);
        }
        OffsetType offsetType = OffsetType.fromByte(reader.readByte());
        this.setNextNodePosition(reader, childIndex, numberOfChildren, offsetType);
        return this.getDeviceIndex(reader, userAgent, index + 1, deviceIndex, matchedUserAgent);
    }

    public static enum OffsetType {
        Bits16,
        Bits32,
        Bits64;


        public static OffsetType fromByte(byte value) {
            switch (value) {
                case 0: {
                    return Bits16;
                }
                case 1: {
                    return Bits32;
                }
                case 2: {
                    return Bits64;
                }
            }
            return null;
        }
    }
}

