/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.search.SearchLists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class MostFrequentFilter
extends ArrayList<Integer> {
    private static final OrderedListSearch search = new OrderedListSearch();
    private static final OrderedListComparator comparator = new OrderedListComparator();

    MostFrequentFilter(List<List<Integer>> lists, int maxResults) throws IOException {
        OrderedList[] localLists = new OrderedList[lists.size()];
        for (int i = 0; i < lists.size(); ++i) {
            localLists[i] = new OrderedList(lists.get(i));
        }
        this.Init(localLists, maxResults);
    }

    MostFrequentFilter(MatchState state) throws IOException {
        OrderedList[] localLists = new OrderedList[state.getNodes().length];
        for (int i = 0; i < state.getNodes().length; ++i) {
            localLists[i] = new OrderedList(state.getNodes()[i].getRankedSignatureIndexes());
        }
        this.Init(localLists, state.getDataSet().maxSignatures);
    }

    private void Init(OrderedList[] lists, int maxResults) throws IOException {
        int topCount = 0;
        if (lists.length == 1) {
            if (lists[0].items.size() < maxResults) {
                maxResults = lists[0].items.size();
            }
            for (int i = 0; i < maxResults; ++i) {
                this.add(lists[0].items.get(i));
            }
        } else if (lists.length > 1) {
            Arrays.sort(lists, comparator);
            for (int listIndex = 0; listIndex < lists.length && lists.length - listIndex >= topCount; ++listIndex) {
                for (OrderedList ol : lists) {
                    ol.reset();
                }
                while (lists[listIndex].moveNext()) {
                    Integer current = lists[listIndex].current();
                    if (this.getHasProcessed(lists, listIndex, current)) continue;
                    int count = this.getCount(lists, listIndex, topCount, current);
                    if (count > topCount) {
                        topCount = count;
                        this.clear();
                    }
                    if (count != topCount) continue;
                    this.add(current);
                }
            }
        }
        Collections.sort(this);
        if (this.size() > maxResults) {
            this.removeRange(maxResults, this.size());
        }
    }

    private boolean getHasProcessed(OrderedList[] lists, int index, Integer current) throws IOException {
        for (int i = index - 1; i >= 0; --i) {
            if (!lists[i].contains(current)) continue;
            return true;
        }
        return false;
    }

    private int getCount(OrderedList[] lists, int index, int topCount, Integer current) throws IOException {
        int count = 1;
        int length = lists.length;
        for (int i = index + 1; i < length && length - index + count > topCount; ++i) {
            if (!lists[i].contains(current)) continue;
            ++count;
        }
        return count;
    }

    private class OrderedList {
        private final List<Integer> items;
        private int nextStartIndex;
        private int currentIndex;

        OrderedList(List<Integer> items) {
            this.items = items;
            this.nextStartIndex = 0;
            this.currentIndex = -1;
        }

        boolean contains(Integer value) throws IOException {
            int itemIndex = search.binarySearch(this.items, value, this.nextStartIndex, this.items.size() - 1);
            this.nextStartIndex = itemIndex < 0 ? ~itemIndex : itemIndex + 1;
            return itemIndex >= 0;
        }

        Integer current() {
            return this.items.get(this.currentIndex);
        }

        boolean moveNext() {
            ++this.currentIndex;
            return this.currentIndex < this.items.size();
        }

        void reset() {
            this.currentIndex = -1;
            this.nextStartIndex = 0;
        }
    }

    private static class OrderedListSearch
    extends SearchLists<Integer, Integer> {
        private OrderedListSearch() {
        }

        @Override
        public int compareTo(Integer item, Integer key) {
            return item.compareTo(key);
        }
    }

    private static class OrderedListComparator
    implements Comparator<OrderedList> {
        private OrderedListComparator() {
        }

        @Override
        public int compare(OrderedList o1, OrderedList o2) {
            return o1.items.size() - o2.items.size();
        }
    }
}

