/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IReadonlyList;
import fiftyone.mobile.detection.IndirectDataset;
import fiftyone.mobile.detection.cache.CacheOptions;
import fiftyone.mobile.detection.cache.ICache;
import fiftyone.mobile.detection.cache.ICacheBuilder;
import fiftyone.mobile.detection.cache.ICacheOptions;
import fiftyone.mobile.detection.cache.IPutCache;
import fiftyone.mobile.detection.cache.IValueLoader;
import fiftyone.mobile.detection.cache.LruCache;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.memory.PropertiesList;
import fiftyone.mobile.detection.entities.stream.IntegerList;
import fiftyone.mobile.detection.factories.AsciiStringFactory;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.factories.CommonFactory;
import fiftyone.mobile.detection.factories.ComponentFactoryV31;
import fiftyone.mobile.detection.factories.ComponentFactoryV32;
import fiftyone.mobile.detection.factories.MapFactory;
import fiftyone.mobile.detection.factories.ProfileOffsetFactory;
import fiftyone.mobile.detection.factories.PropertyFactory;
import fiftyone.mobile.detection.factories.RootNodeFactory;
import fiftyone.mobile.detection.factories.SignatureFactoryV31;
import fiftyone.mobile.detection.factories.SignatureFactoryV32;
import fiftyone.mobile.detection.factories.ValueFactory;
import fiftyone.mobile.detection.factories.stream.NodeStreamFactoryV31;
import fiftyone.mobile.detection.factories.stream.NodeStreamFactoryV32;
import fiftyone.mobile.detection.factories.stream.ProfileStreamFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DatasetBuilder {
    public static final int STRINGS_CACHE_SIZE = 5000;
    public static final int NODES_CACHE_SIZE = 15000;
    public static final int VALUES_CACHE_SIZE = 5000;
    public static final int PROFILES_CACHE_SIZE = 600;
    public static final int SIGNATURES_CACHE_SIZE = 500;
    private static ICacheBuilder lruBuilder = LruCache.builder();
    private static EnumMap<CacheType, ICacheOptions> defaultCacheSizes = new EnumMap(CacheType.class);
    private static EnumMap<CacheType, ICacheOptions> MtCacheSizes;
    private static EnumMap<CacheType, ICacheOptions> StCacheSizes;
    private static EnumMap<CacheType, ICacheOptions> StlmCacheSizes;
    private static EnumMap<CacheType, ICacheOptions> MtlmCacheSizes;
    private static EnumMap<CacheType, ICacheOptions> HcCacheSizes;
    private java.util.Map<CacheType, ICacheOptions> cacheMap = new EnumMap<CacheType, ICacheOptions>(CacheType.class);

    private DatasetBuilder() {
    }

    public static BuildFromFile file() {
        DatasetBuilder datasetBuilder = new DatasetBuilder();
        datasetBuilder.getClass();
        return datasetBuilder.new BuildFromFile();
    }

    public static BuildFromBuffer buffer() {
        DatasetBuilder datasetBuilder = new DatasetBuilder();
        datasetBuilder.getClass();
        return datasetBuilder.new BuildFromBuffer();
    }

    private static <T> EntityLoader<T> getLoaderFor(Header header, ICache cache, IndirectDataset dataset, BaseEntityFactory factory) {
        EntityLoader loader;
        if (cache == null) {
            loader = new EntityLoader(header, dataset, factory);
        } else if (cache instanceof LruCache) {
            loader = new LruEntityLoader(header, dataset, factory, (LruCache)cache);
        } else if (cache instanceof IPutCache) {
            loader = new CachedEntityLoader(header, dataset, factory, (IPutCache)cache);
        } else {
            throw new IllegalStateException("Cache must be null, LruCache or IPutCache");
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadForStreaming(IndirectDataset dataSet, java.util.Map<CacheType, ICacheOptions> cacheConfiguration) throws IOException {
        BinaryReader reader = dataSet.pool.getReader();
        try {
            MemoryFixedList<ProfileOffset> profileOffsets;
            MemoryFixedList<Node> rootNodes;
            PropertiesList properties;
            MemoryFixedList<Map> maps;
            MemoryFixedList<Component> components;
            java.util.Map<CacheType, ICache> cacheMap = DatasetBuilder.buildCaches(cacheConfiguration);
            dataSet.setCacheMap(cacheMap);
            reader.setPos(0);
            CommonFactory.loadHeader(dataSet, reader);
            EntityLoader loader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.StringsCache), dataSet, new AsciiStringFactory());
            dataSet.strings = new StreamList(loader);
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV31());
                    break;
                }
                case PatternV32: {
                    components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV32());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown data version number");
                }
            }
            dataSet.components = components;
            dataSet.maps = maps = new MemoryFixedList<Map>(dataSet, reader, new MapFactory());
            dataSet.properties = properties = new PropertiesList((Dataset)dataSet, reader, new PropertyFactory());
            EntityLoader valueLoader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.ValuesCache), dataSet, new ValueFactory());
            dataSet.values = new StreamList(valueLoader);
            EntityLoader profileLoader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.ProfilesCache), dataSet, new ProfileStreamFactory());
            dataSet.profiles = new StreamList(profileLoader);
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    EntityLoader signature31Loader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.SignaturesCache), dataSet, new SignatureFactoryV31(dataSet));
                    dataSet.signatures = new StreamList(signature31Loader);
                    break;
                }
                case PatternV32: {
                    EntityLoader signature32Loader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.SignaturesCache), dataSet, new SignatureFactoryV32(dataSet));
                    dataSet.signatures = new StreamList(signature32Loader);
                    dataSet.signatureNodeOffsets = new IntegerList(dataSet, reader);
                    dataSet.nodeRankedSignatureIndexes = new IntegerList(dataSet, reader);
                }
            }
            dataSet.rankedSignatureIndexes = new IntegerList(dataSet, reader);
            switch (dataSet.versionEnum) {
                case PatternV31: {
                    EntityLoader node31Loader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.NodesCache), dataSet, new NodeStreamFactoryV31());
                    dataSet.nodes = new StreamList(node31Loader);
                    break;
                }
                case PatternV32: {
                    EntityLoader node32Loader = DatasetBuilder.getLoaderFor(new Header(reader), cacheMap.get((Object)CacheType.NodesCache), dataSet, new NodeStreamFactoryV32());
                    dataSet.nodes = new StreamList(node32Loader);
                }
            }
            dataSet.rootNodes = rootNodes = new MemoryFixedList<Node>(dataSet, reader, new RootNodeFactory());
            dataSet.profileOffsets = profileOffsets = new MemoryFixedList<ProfileOffset>(dataSet, reader, new ProfileOffsetFactory());
            reader.setPos(components.header.getStartPosition());
            components.read(reader);
            reader.setPos(maps.header.getStartPosition());
            maps.read(reader);
            reader.setPos(properties.header.getStartPosition());
            properties.read(reader);
            reader.setPos(rootNodes.header.getStartPosition());
            rootNodes.read(reader);
            reader.setPos(profileOffsets.header.getStartPosition());
            profileOffsets.read(reader);
        }
        finally {
            if (reader != null) {
                dataSet.pool.release(reader);
            }
        }
    }

    private static java.util.Map<CacheType, ICache> buildCaches(java.util.Map<CacheType, ICacheOptions> cacheConfiguration) {
        EnumMap<CacheType, ICache> caches = new EnumMap<CacheType, ICache>(CacheType.class);
        for (CacheType cacheType : cacheConfiguration.keySet()) {
            ICacheOptions options = cacheConfiguration.get((Object)cacheType);
            if (options.getBuilder() == null) continue;
            caches.put(cacheType, options.getBuilder().build(options.getSize()));
        }
        return caches;
    }

    static /* synthetic */ EnumMap access$000() {
        return defaultCacheSizes;
    }

    static /* synthetic */ EnumMap access$100() {
        return StlmCacheSizes;
    }

    static /* synthetic */ EnumMap access$200() {
        return StCacheSizes;
    }

    static /* synthetic */ EnumMap access$300() {
        return MtlmCacheSizes;
    }

    static /* synthetic */ EnumMap access$400() {
        return MtCacheSizes;
    }

    static /* synthetic */ EnumMap access$500() {
        return HcCacheSizes;
    }

    static {
        defaultCacheSizes.put(CacheType.StringsCache, new CacheOptions(5000, lruBuilder));
        defaultCacheSizes.put(CacheType.NodesCache, new CacheOptions(15000, lruBuilder));
        defaultCacheSizes.put(CacheType.ValuesCache, new CacheOptions(5000, lruBuilder));
        defaultCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(600, lruBuilder));
        defaultCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(500, lruBuilder));
        MtCacheSizes = new EnumMap(CacheType.class);
        MtCacheSizes.put(CacheType.StringsCache, new CacheOptions(500, lruBuilder));
        MtCacheSizes.put(CacheType.NodesCache, new CacheOptions(90000, lruBuilder));
        MtCacheSizes.put(CacheType.ValuesCache, new CacheOptions(500, lruBuilder));
        MtCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(7500, lruBuilder));
        MtCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(60000, lruBuilder));
        StCacheSizes = new EnumMap(CacheType.class);
        StCacheSizes.put(CacheType.StringsCache, new CacheOptions(66000, lruBuilder));
        StCacheSizes.put(CacheType.NodesCache, new CacheOptions(100000, lruBuilder));
        StCacheSizes.put(CacheType.ValuesCache, new CacheOptions(14000, lruBuilder));
        StCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(14000, lruBuilder));
        StCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(100000, lruBuilder));
        StlmCacheSizes = new EnumMap(CacheType.class);
        StlmCacheSizes.put(CacheType.StringsCache, new CacheOptions(0, lruBuilder));
        StlmCacheSizes.put(CacheType.NodesCache, new CacheOptions(40000, lruBuilder));
        StlmCacheSizes.put(CacheType.ValuesCache, new CacheOptions(40000, lruBuilder));
        StlmCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(40000, lruBuilder));
        StlmCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(0, lruBuilder));
        MtlmCacheSizes = new EnumMap(CacheType.class);
        MtlmCacheSizes.put(CacheType.StringsCache, new CacheOptions(20500, lruBuilder));
        MtlmCacheSizes.put(CacheType.NodesCache, new CacheOptions(40000, lruBuilder));
        MtlmCacheSizes.put(CacheType.ValuesCache, new CacheOptions(500, lruBuilder));
        MtlmCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(20500, lruBuilder));
        MtlmCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(0, lruBuilder));
        HcCacheSizes = new EnumMap(CacheType.class);
        HcCacheSizes.put(CacheType.StringsCache, new CacheOptions(0, null));
        HcCacheSizes.put(CacheType.NodesCache, new CacheOptions(0, null));
        HcCacheSizes.put(CacheType.ValuesCache, new CacheOptions(0, null));
        HcCacheSizes.put(CacheType.ProfilesCache, new CacheOptions(0, null));
        HcCacheSizes.put(CacheType.SignaturesCache, new CacheOptions(0, null));
    }

    private static class StreamList<T extends BaseEntity>
    implements IReadonlyList<T> {
        private EntityLoader<T> loader;

        StreamList(EntityLoader<T> loader) {
            this.loader = loader;
        }

        @Override
        public T get(int i) throws IOException {
            return (T)((BaseEntity)this.loader.load(i));
        }

        @Override
        public int size() {
            return this.loader.getHeader().getCount();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int count = 0;
                int position = 0;
                int total = StreamList.access$1100(StreamList.this).getHeader().getCount();

                @Override
                public boolean hasNext() {
                    return this.count < this.total;
                }

                @Override
                public T next() {
                    try {
                        if (this.count >= this.total) {
                            throw new NoSuchElementException();
                        }
                        Object result = StreamList.this.get(this.position);
                        ++this.count;
                        this.position = StreamList.this.loader.nextPosition(this.position, result);
                        return result;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove not supported");
                }
            };
        }
    }

    private static class CachedEntityLoader<V>
    extends EntityLoader<V> {
        private IPutCache<Integer, V> cache;

        CachedEntityLoader(Header header, IndirectDataset dataset, BaseEntityFactory<V> entityFactory, IPutCache<Integer, V> cache) {
            super(header, dataset, entityFactory);
            this.cache = cache;
        }

        @Override
        public V load(Integer key) throws IOException {
            Object value = this.cache.get(key);
            if (value == null && (value = super.load(key)) != null) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    private static class LruEntityLoader<V>
    extends EntityLoader<V> {
        private LruCache<Integer, V> cache;

        LruEntityLoader(Header header, IndirectDataset dataset, BaseEntityFactory<V> entityFactory, LruCache<Integer, V> cache) {
            super(header, dataset, entityFactory);
            this.cache = cache;
            this.cache.setCacheLoader(new EntityLoader<V>(header, dataset, entityFactory));
        }

        @Override
        public V load(Integer key) throws IOException {
            return this.cache.get(key);
        }
    }

    private static class EntityLoader<V>
    implements IValueLoader<Integer, V> {
        final IndirectDataset dataset;
        final BaseEntityFactory<V> entityFactory;
        final Header header;
        boolean fixedLength = false;

        EntityLoader(Header header, IndirectDataset dataset, BaseEntityFactory<V> entityFactory) {
            this.dataset = dataset;
            this.entityFactory = entityFactory;
            this.header = header;
            try {
                this.getEntityFactory().getLength();
                this.fixedLength = true;
            }
            catch (UnsupportedOperationException ignored) {
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V load(Integer key) throws IOException {
            BinaryReader reader = this.dataset.pool.getReader();
            try {
                if (this.fixedLength) {
                    reader.setPos(this.header.getStartPosition() + this.getEntityFactory().getLength() * key);
                } else {
                    reader.setPos(this.header.getStartPosition() + key);
                }
                V v = this.entityFactory.create(this.dataset, key, reader);
                return v;
            }
            finally {
                this.dataset.pool.release(reader);
            }
        }

        public int nextPosition(int position, V result) throws IOException {
            if (this.fixedLength) {
                return ++position;
            }
            return position + this.getEntityFactory().getLength(result);
        }

        public BaseEntityFactory<V> getEntityFactory() {
            return this.entityFactory;
        }

        public Header getHeader() {
            return this.header;
        }
    }

    public class BuildFromFile
    extends Cachable<BuildFromFile> {
        private boolean isTempFile;
        private Date lastModified;

        private BuildFromFile() {
            this.isTempFile = false;
            this.lastModified = null;
        }

        public BuildFromFile setTempFile() {
            this.isTempFile = true;
            return this;
        }

        public BuildFromFile setTempFile(boolean isTemp) {
            this.isTempFile = isTemp;
            return this;
        }

        public BuildFromFile lastModified(Date date) {
            this.lastModified = date;
            return this;
        }

        public IndirectDataset build(String filename) throws IOException {
            Date modDate = this.lastModified;
            if (modDate == null) {
                modDate = new Date(new File(filename).lastModified());
            }
            IndirectDataset dataSet = new IndirectDataset(filename, modDate, Modes.FILE, this.isTempFile);
            DatasetBuilder.loadForStreaming(dataSet, DatasetBuilder.this.cacheMap);
            return dataSet;
        }
    }

    public class BuildFromBuffer
    extends Cachable<BuildFromBuffer> {
        private BuildFromBuffer() {
        }

        public IndirectDataset build(byte[] buffer) throws IOException {
            IndirectDataset dataSet = new IndirectDataset(buffer, Modes.MEMORY_MAPPED);
            DatasetBuilder.loadForStreaming(dataSet, DatasetBuilder.this.cacheMap);
            return dataSet;
        }
    }

    public class Cachable<T extends Cachable<T>> {
        private Cachable() {
        }

        public T setCacheBuilder(CacheType cacheType, ICacheBuilder builder) {
            if (DatasetBuilder.this.cacheMap.containsKey((Object)cacheType)) {
                ((ICacheOptions)DatasetBuilder.this.cacheMap.get((Object)cacheType)).setBuilder(builder);
            } else {
                DatasetBuilder.this.cacheMap.put(cacheType, new CacheOptions(CacheTemplate.Default.getCacheConfiguration().get((Object)cacheType).getSize(), builder));
            }
            return (T)this;
        }

        public T setCacheBuilders(java.util.Map<CacheType, ICacheBuilder> map) {
            for (CacheType cacheType : map.keySet()) {
                this.setCacheBuilder(cacheType, map.get((Object)cacheType));
            }
            return (T)this;
        }

        public T setCacheSize(CacheType cacheType, int cacheSize) {
            if (DatasetBuilder.this.cacheMap.containsKey((Object)cacheType)) {
                ((ICacheOptions)DatasetBuilder.this.cacheMap.get((Object)cacheType)).setSize(cacheSize);
            } else {
                DatasetBuilder.this.cacheMap.put(cacheType, new CacheOptions(cacheSize, CacheTemplate.Default.getCacheConfiguration().get((Object)cacheType).getBuilder()));
            }
            return (T)this;
        }

        public T setCacheSizes(java.util.Map<CacheType, Integer> map) {
            for (CacheType cacheType : map.keySet()) {
                this.setCacheSize(cacheType, map.get((Object)cacheType));
            }
            return (T)this;
        }

        public T configureCache(CacheType cacheType, ICacheOptions options) {
            DatasetBuilder.this.cacheMap.put(cacheType, options);
            return (T)this;
        }

        public T configureCaches(java.util.Map<CacheType, ICacheOptions> map) {
            DatasetBuilder.this.cacheMap.putAll(map);
            return (T)this;
        }

        public T configureDefaultCaches() {
            this.configureCaches(CacheTemplate.Default.getCacheConfiguration());
            return (T)this;
        }

        public T configureCachesFromTemplate(CacheTemplate template) {
            return this.configureCachesFromCacheSet(template);
        }

        public T configureCachesFromCacheSet(CacheSet set) {
            this.configureCaches(set.getCacheConfiguration());
            return (T)this;
        }
    }

    public static enum CacheTemplate implements CacheSet
    {
        Default(DatasetBuilder.access$000()),
        SingleThreadLowMemory(DatasetBuilder.access$100()),
        SingleThread(DatasetBuilder.access$200()),
        MultiThreadLowMemory(DatasetBuilder.access$300()),
        MultiThread(DatasetBuilder.access$400()),
        HighConcurrency(DatasetBuilder.access$500());

        private EnumMap<CacheType, ICacheOptions> configuration = new EnumMap(CacheType.class);

        private CacheTemplate(EnumMap<CacheType, ICacheOptions> configuration) {
            this.configuration.putAll(configuration);
        }

        @Override
        public java.util.Map<CacheType, ICacheOptions> getCacheConfiguration() {
            return this.configuration;
        }
    }

    public static interface CacheSet {
        public java.util.Map<CacheType, ICacheOptions> getCacheConfiguration();
    }

    public static enum CacheType {
        StringsCache,
        NodesCache,
        ValuesCache,
        ProfilesCache,
        SignaturesCache;

    }
}

