/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.ISimpleList;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MemoryIntegerList
implements ISimpleList {
    private final Header header;
    protected final Integer[] array;

    public MemoryIntegerList(BinaryReader reader) {
        this.header = new Header(reader);
        this.array = new Integer[this.header.getCount()];
    }

    public void read(BinaryReader reader) {
        for (int i = 0; i < this.header.getCount(); ++i) {
            this.array[i] = reader.readInt32();
        }
    }

    @Override
    public int get(int index) {
        if (index > this.array.length || index < 0) {
            throw new ArrayIndexOutOfBoundsException("The requested element is out of bounds for this array.");
        }
        return this.array[index];
    }

    @Override
    public List<Integer> getRange(int index, int count) {
        List<Integer> list = Collections.unmodifiableList(Arrays.asList(this.array));
        return list.subList(index, index + count);
    }

    @Override
    public int size() {
        return this.array.length;
    }
}

