/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.NodeIndexBase;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NodeIndex
extends NodeIndexBase
implements Comparable<NodeIndex> {
    final boolean isString;
    private final byte[] value;
    private volatile byte[] characters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getCharacters() throws IOException {
        byte[] localCharacters = this.characters;
        if (localCharacters == null) {
            NodeIndex nodeIndex = this;
            synchronized (nodeIndex) {
                localCharacters = this.characters;
                if (localCharacters == null) {
                    this.characters = localCharacters = NodeIndex.getCharacters(this.getDataSet(), this.isString, this.value);
                }
            }
        }
        return localCharacters;
    }

    public NodeIndex(Dataset dataSet, int index, boolean isString, byte[] value, int relatedNodeOffset) {
        super(dataSet, index, relatedNodeOffset);
        this.isString = isString;
        this.value = value;
    }

    @Override
    void init() throws IOException {
        super.init();
        if (this.characters == null) {
            this.characters = NodeIndex.getCharacters(this.getDataSet(), this.isString, this.value);
        }
    }

    private static byte[] getCharacters(Dataset dataSet, boolean isString, byte[] value) throws IOException {
        if (isString) {
            return dataSet.strings.get((int)Integer.reverseBytes((int)ByteBuffer.wrap((byte[])value).getInt())).value;
        }
        return value;
    }

    int compareTo(byte[] other, int startIndex) throws IOException {
        byte[] c = this.getCharacters();
        int i = c.length - 1;
        int o = startIndex + c.length - 1;
        while (i >= 0) {
            int difference = c[i] - other[o];
            if (difference != 0) {
                return difference;
            }
            --i;
            --o;
        }
        return 0;
    }

    @Override
    public int compareTo(NodeIndex other) {
        try {
            return this.compareTo(other.getCharacters(), 0);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public String toString() {
        try {
            return String.format("%s[%d]]", new String(this.getCharacters()), this.relatedNodeOffset);
        }
        catch (IOException e) {
            return super.toString();
        }
    }
}

