/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.entities.stream.Pool;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class Profile
extends fiftyone.mobile.detection.entities.Profile {
    private final int position;
    private final int valueIndexesCount;
    private final int signatureIndexesCount;
    private final Pool pool;

    public Profile(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index, reader);
        this.pool = dataSet.pool;
        this.valueIndexesCount = reader.readInt32();
        this.signatureIndexesCount = reader.readInt32();
        this.position = reader.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getValueIndexes() throws IOException {
        int[] localValueIndexes = this.valueIndexes;
        if (localValueIndexes == null) {
            Profile profile = this;
            synchronized (profile) {
                localValueIndexes = this.valueIndexes;
                if (localValueIndexes == null) {
                    BinaryReader reader = this.pool.getReader();
                    try {
                        reader.setPos(this.position);
                        this.valueIndexes = localValueIndexes = BaseEntity.readIntegerArray(reader, this.valueIndexesCount);
                    }
                    finally {
                        this.pool.release(reader);
                    }
                }
            }
        }
        return localValueIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSignatureIndexes() throws IOException {
        int[] localSignatureIndexes = this.signatureIndexes;
        if (localSignatureIndexes == null) {
            Profile profile = this;
            synchronized (profile) {
                localSignatureIndexes = this.signatureIndexes;
                if (localSignatureIndexes == null) {
                    BinaryReader reader = this.pool.getReader();
                    try {
                        int offset = this.valueIndexesCount * 4;
                        reader.setPos(this.position + offset);
                        this.signatureIndexes = localSignatureIndexes = BaseEntity.readIntegerArray(reader, this.signatureIndexesCount);
                    }
                    finally {
                        this.pool.release(reader);
                    }
                }
            }
        }
        return localSignatureIndexes;
    }
}

