/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.webapp;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IDisposable;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.Provider;
import fiftyone.mobile.detection.factories.MemoryFactory;
import fiftyone.mobile.detection.factories.StreamFactory;
import fiftyone.mobile.detection.webapp.ProfileOverride;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebProvider
extends Provider
implements IDisposable {
    private static final Object lock = new Object();
    private static WebProvider activeProvider;
    private static final Logger logger;
    private static final String RESULT_ATTIBUTE = "51D_RESULT";
    private String sourceDataFile = null;

    @Deprecated
    public WebProvider() throws IOException {
        throw new Error("No embedded data as of version 3.2.");
    }

    public WebProvider(Dataset dataset) {
        super(dataset);
    }

    public WebProvider(Dataset dataset, int n) {
        super(dataset, n);
    }

    public void dispose() {
        File file;
        if (this.dataSet != null) {
            this.dataSet.dispose();
        }
        if (this.sourceDataFile != null && (file = new File(this.sourceDataFile)).exists()) {
            file.delete();
            logger.debug(String.format("Deleted temporary data file '%s'", this.sourceDataFile));
        }
        if (activeProvider == this) {
            activeProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebProvider getActiveProvider(ServletContext servletContext) {
        if (activeProvider == null) {
            Object object = lock;
            synchronized (object) {
                if (activeProvider == null) {
                    activeProvider = WebProvider.create(servletContext);
                }
            }
        }
        return activeProvider;
    }

    static File getBinaryFilePath(ServletContext servletContext) {
        String string = servletContext.getInitParameter("BINARY_FILE_PATH");
        return string == null ? null : new File(String.format("%s%s%s", servletContext.getRealPath("WEB-INF"), File.separator, string));
    }

    private static void cleanTemporaryFiles(File[] fileArray) {
        try {
            for (File file : fileArray) {
                try {
                    if (file.delete()) continue;
                    logger.debug(String.format("Could not delete temporary file '%s'. It may be in user by another provider.", file));
                }
                catch (SecurityException securityException) {
                    logger.debug(String.format("Exception deleting temporary file '%s'", file), (Throwable)securityException);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Exception cleaning temporary files", (Throwable)exception);
        }
    }

    private static void copyFile(File file, String string) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[1026];
        while ((n = fileInputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    private static String getTempFileName(File file, File file2) {
        return file.getAbsolutePath() + String.format("\\%s.%s.tmp", file2.getName(), UUID.randomUUID().toString());
    }

    private static Date getDataFileDate(String string) throws IOException {
        fiftyone.mobile.detection.entities.stream.Dataset dataset = StreamFactory.create((String)string, (boolean)false);
        return dataset.published;
    }

    private static String getTempWorkingFile(File file, File file2) throws FileNotFoundException, IOException {
        String string = null;
        if (file2.exists()) {
            File[] fileArray;
            String string2 = file2.getAbsolutePath();
            String string3 = file2.getName();
            Date date = WebProvider.getDataFileDate(string2);
            for (File file3 : fileArray = file.listFiles()) {
                String string4 = file3.getAbsolutePath();
                String string5 = file3.getName();
                if (string4.equals(string2) || !string4.startsWith(string3) || !string4.endsWith(".tmp")) continue;
                try {
                    Date date2 = WebProvider.getDataFileDate(string4);
                    if (!date2.equals(date)) continue;
                    logger.info("Using existing temp data file with published data %s - \"%s\"", (Object)date2.toString(), (Object)string4);
                    return string5;
                }
                catch (Exception exception) {
                    logger.info("Error while reading temporary data file \"%s\": %s", (Object)string4, (Object)exception.getMessage());
                }
            }
            string = WebProvider.getTempFileName(file, file2);
            WebProvider.copyFile(file2, string);
            logger.info("Created temp data file - \"%s\"", (Object)string);
        }
        return string;
    }

    private static WebProvider create(ServletContext servletContext) {
        WebProvider webProvider = null;
        File file = new File(servletContext.getRealPath("WEB-INF"));
        boolean bl = "True".equalsIgnoreCase(servletContext.getInitParameter("MEMORY_MODE"));
        final File file2 = WebProvider.getBinaryFilePath(servletContext);
        if (file2 != null) {
            WebProvider.cleanTemporaryFiles(file.listFiles(new FilenameFilter(){
                private final String filterRegex;
                {
                    this.filterRegex = String.format("%s\\..+\\.tmp", file2.getName());
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.matches(this.filterRegex);
                }
            }));
            try {
                if (file2.exists()) {
                    if (bl) {
                        logger.info(String.format("Creating memory provider from binary data file '%s'.", file2.getAbsolutePath()));
                        webProvider = new WebProvider(MemoryFactory.create((String)file2.getAbsolutePath()));
                    } else {
                        String string = WebProvider.getTempWorkingFile(file, file2);
                        logger.info(String.format("Creating stream provider from binary data file '%s'.", string));
                        webProvider = new WebProvider((Dataset)StreamFactory.create((String)string, (boolean)false));
                        webProvider.sourceDataFile = string;
                    }
                    logger.info(String.format("Created provider from binary data file '%s'.", file2.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                logger.error(String.format("Exception processing device data from binary file '%s'. Enable debug level logging and try again to help identify cause.", file2), (Throwable)exception);
                webProvider = null;
            }
        }
        if (webProvider == null || webProvider.dataSet == null) {
            logger.error(String.format("Failed to create a Web Provider. The path to 51Degrees device data file is not set in the Constants.", new Object[0]));
            throw new Error("Could not create a Web Provider. Path to 51Degrees data file was not set in the Constants.");
        }
        return webProvider;
    }

    public Match match(HttpServletRequest httpServletRequest) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.dataSet.getHttpHeaders()) {
            Enumeration enumeration;
            if (httpServletRequest.getHeader(string) == null || !(enumeration = httpServletRequest.getHeaders(string)).hasMoreElements()) continue;
            String string2 = (String)enumeration.nextElement();
            hashMap.put(string, string2);
        }
        return super.match(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String[]> getResult(HttpServletRequest httpServletRequest) throws IOException {
        boolean bl = ProfileOverride.hasOverrides(httpServletRequest);
        Map map = (Map)httpServletRequest.getAttribute(RESULT_ATTIBUTE);
        if (map == null || bl) {
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            synchronized (httpServletRequest2) {
                Match match;
                map = (Map)httpServletRequest.getAttribute(RESULT_ATTIBUTE);
                if ((map == null || bl) && map == null && (match = WebProvider.getActiveProvider(httpServletRequest.getServletContext()).match(httpServletRequest)) != null) {
                    ProfileOverride.override(httpServletRequest, match);
                    httpServletRequest.setAttribute(RESULT_ATTIBUTE, (Object)match.getResults());
                    map = match.getResults();
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        if (activeProvider != null) {
            Object object = lock;
            synchronized (object) {
                if (activeProvider != null) {
                    WebProvider webProvider = activeProvider;
                    activeProvider = null;
                    webProvider.dispose();
                }
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(WebProvider.class);
    }

    static interface MatchResult
    extends Map<String, String[]> {
    }
}

